package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[数据源]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZDATASOURCE", resultMap = "DstDataSourceResultMap")
public class DstDataSource extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标识
     */
    @DEField(defaultValue = "dsname", defaultValueType = DEFieldDefaultValueType.PARAM, isKeyField = true)
    @TableId(value = "dsid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ds_id")
    @JsonProperty("ds_id")
    private String dsId;
    /**
     * 数据源名称
     */
    @TableField(value = "dsname")
    @JSONField(name = "ds_name")
    @JsonProperty("ds_name")
    private String dsName;
    /**
     * 类型
     */
    @TableField(value = "dstype")
    @JSONField(name = "ds_type")
    @JsonProperty("ds_type")
    private String dsType;
    /**
     * 配置
     */
    @TableField(value = "dscfg")
    @JSONField(name = "ds_cfg")
    @JsonProperty("ds_cfg")
    private String dsCfg;



    /**
     * 设置 [数据源名称]
     */
    public void setDsName(String dsName) {
        this.dsName = dsName;
        this.modify("dsname", dsName);
    }

    /**
     * 设置 [类型]
     */
    public void setDsType(String dsType) {
        this.dsType = dsType;
        this.modify("dstype", dsType);
    }

    /**
     * 设置 [配置]
     */
    public void setDsCfg(String dsCfg) {
        this.dsCfg = dsCfg;
        this.modify("dscfg", dsCfg);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("dsid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


