package cn.ibizlab.core.avuedata.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[可视化分类表]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "blade_visual_category", resultMap = "BladeVisualCategoryResultMap")
public class BladeVisualCategory extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @DEField(isKeyField = true)
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @JSONField(name = "id")
    @JsonProperty("id")
    private Long id;
    /**
     * 分类键值
     */
    @DEField(name = "category_key")
    @TableField(value = "category_key")
    @JSONField(name = "categorykey")
    @JsonProperty("categorykey")
    private String categorykey;
    /**
     * 分类名称
     */
    @DEField(name = "category_value")
    @TableField(value = "category_value")
    @JSONField(name = "categoryvalue")
    @JsonProperty("categoryvalue")
    private String categoryvalue;
    /**
     * 是否已删除
     */
    @DEField(name = "is_deleted", preType = DEPredefinedFieldType.LOGICVALID, logicval = "0", logicdelval = "1")
    @TableLogic(value = "0", delval = "1")
    @TableField(value = "is_deleted")
    @JSONField(name = "isdeleted")
    @JsonProperty("isdeleted")
    private Integer isdeleted;



    /**
     * 设置 [分类键值]
     */
    public void setCategorykey(String categorykey) {
        this.categorykey = categorykey;
        this.modify("category_key", categorykey);
    }

    /**
     * 设置 [分类名称]
     */
    public void setCategoryvalue(String categoryvalue) {
        this.categoryvalue = categoryvalue;
        this.modify("category_value", categoryvalue);
    }


    @Override
    public Serializable getDefaultKey(boolean gen) {
        return IdWorker.getId();
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


