package cn.ibizlab.core.avuedata.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[可视化表]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "blade_visual", resultMap = "BladeVisualResultMap")
public class BladeVisual extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @DEField(isKeyField = true)
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @JSONField(name = "id")
    @JsonProperty("id")
    private Long id;
    /**
     * 大屏标题
     */
    @TableField(value = "title")
    @JSONField(name = "title")
    @JsonProperty("title")
    private String title;
    /**
     * 大屏类型
     */
    @TableField(value = "category")
    @JSONField(name = "category")
    @JsonProperty("category")
    private Integer category;
    /**
     * 发布密码
     */
    @TableField(value = "password")
    @JSONField(name = "password")
    @JsonProperty("password")
    private String password;
    /**
     * 大屏背景
     */
    @DEField(name = "background_url")
    @TableField(value = "background_url")
    @JSONField(name = "backgroundurl")
    @JsonProperty("backgroundurl")
    private String backgroundurl;
    /**
     * 状态
     */
    @TableField(value = "status")
    @JSONField(name = "status")
    @JsonProperty("status")
    private Integer status;
    /**
     * 创建时间
     */
    @DEField(name = "create_time", preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createtime", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createtime")
    private Timestamp createtime;
    /**
     * 创建部门
     */
    @DEField(name = "create_dept")
    @TableField(value = "create_dept")
    @JSONField(name = "createdept")
    @JsonProperty("createdept")
    private Long createdept;
    /**
     * 创建人
     */
    @DEField(name = "create_user")
    @TableField(value = "create_user")
    @JSONField(name = "createuser")
    @JsonProperty("createuser")
    private Long createuser;
    /**
     * 修改时间
     */
    @DEField(name = "update_time", preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatetime", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatetime")
    private Timestamp updatetime;
    /**
     * 修改人
     */
    @DEField(name = "update_user")
    @TableField(value = "update_user")
    @JSONField(name = "updateuser")
    @JsonProperty("updateuser")
    private Long updateuser;
    /**
     * 是否已删除
     */
    @DEField(name = "is_deleted", preType = DEPredefinedFieldType.LOGICVALID, logicval = "0", logicdelval = "1")
    @TableLogic(value = "0", delval = "1")
    @TableField(value = "is_deleted")
    @JSONField(name = "isdeleted")
    @JsonProperty("isdeleted")
    private Integer isdeleted;
    /**
     * 配置json
     */
    @TableField(exist = false)
    @JSONField(name = "detail")
    @JsonProperty("detail")
    private String detail;
    /**
     * 组件json
     */
    @TableField(exist = false)
    @JSONField(name = "component")
    @JsonProperty("component")
    private String component;



    /**
     * 设置 [大屏标题]
     */
    public void setTitle(String title) {
        this.title = title;
        this.modify("title", title);
    }

    /**
     * 设置 [大屏类型]
     */
    public void setCategory(Integer category) {
        this.category = category;
        this.modify("category", category);
    }

    /**
     * 设置 [发布密码]
     */
    public void setPassword(String password) {
        this.password = password;
        this.modify("password", password);
    }

    /**
     * 设置 [大屏背景]
     */
    public void setBackgroundurl(String backgroundurl) {
        this.backgroundurl = backgroundurl;
        this.modify("background_url", backgroundurl);
    }

    /**
     * 设置 [状态]
     */
    public void setStatus(Integer status) {
        this.status = status;
        this.modify("status", status);
    }

    /**
     * 设置 [创建部门]
     */
    public void setCreatedept(Long createdept) {
        this.createdept = createdept;
        this.modify("create_dept", createdept);
    }

    /**
     * 设置 [创建人]
     */
    public void setCreateuser(Long createuser) {
        this.createuser = createuser;
        this.modify("create_user", createuser);
    }

    /**
     * 设置 [修改人]
     */
    public void setUpdateuser(Long updateuser) {
        this.updateuser = updateuser;
        this.modify("update_user", updateuser);
    }


    @Override
    public Serializable getDefaultKey(boolean gen) {
        return IdWorker.getId();
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


