package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.MetaModel;
import cn.ibizlab.core.lite.filter.MetaModelSearchContext;
import cn.ibizlab.core.lite.service.IMetaModelService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.MetaModelMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[模型] 服务对象接口实现
 */
@Slf4j
@Service("MetaModelServiceImpl")
public class MetaModelServiceImpl extends ServiceImpl<MetaModelMapper, MetaModel> implements IMetaModelService {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IDstSystemService dstsystemService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(MetaModel et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<MetaModel> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(MetaModel et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("modelid", et.getId()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<MetaModel> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public MetaModel get(String key) {
        MetaModel et = getById(key);
        if(et == null){
            et = new MetaModel();
            et.setId(key);
        }
        else {
        }
        return et;
    }

    @Override
    public MetaModel getDraft(MetaModel et) {
        return et;
    }

    @Override
    @Transactional
    public MetaModel change(MetaModel et) {
        //自定义代码
        return et;
    }

    @Override
    @Transactional
    public boolean changeBatch(List<MetaModel> etList) {
        for(MetaModel et : etList) {
            change(et);
        }
        return true;
    }

    @Override
    public boolean checkKey(MetaModel et) {
        return (!ObjectUtils.isEmpty(et.getId())) && (!Objects.isNull(this.getById(et.getId())));
    }
    @Override
    @Transactional
    public boolean save(MetaModel et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(MetaModel et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? getProxyService().update(et) : getProxyService().create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<MetaModel> list) {
        List<MetaModel> create = new ArrayList<>();
        List<MetaModel> update = new ArrayList<>();
        for (MetaModel et : list) {
            if (ObjectUtils.isEmpty(et.getId()) || ObjectUtils.isEmpty(getById(et.getId()))) {
                create.add(et);
            } else {
                update.add(et);
            }
        }
        if (create.size() > 0) {
            getProxyService().createBatch(create);
        }
        if (update.size() > 0) {
            getProxyService().updateBatch(update);
        }
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<MetaModel> list) {
        List<MetaModel> create = new ArrayList<>();
        List<MetaModel> update = new ArrayList<>();
        for (MetaModel et : list) {
            if (ObjectUtils.isEmpty(et.getId()) || ObjectUtils.isEmpty(getById(et.getId()))) {
                create.add(et);
            } else {
                update.add(et);
            }
        }
        if (create.size() > 0) {
            getProxyService().createBatch(create);
        }
        if (update.size() > 0) {
            getProxyService().updateBatch(update);
        }
    }


	@Override
    public List<MetaModel> selectBySystemId(String pssystemid) {
        return baseMapper.selectBySystemId(pssystemid);
    }
    @Override
    public void removeBySystemId(String pssystemid) {
        this.remove(new QueryWrapper<MetaModel>().eq("systemid",pssystemid));
    }


    /**
     * 查询集合 数据集
     */
    @Override
    public Page<MetaModel> searchDefault(MetaModelSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<MetaModel> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<MetaModel>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }






    public IMetaModelService getProxyService() {
        return cn.ibizlab.util.security.SpringContextHolder.getBean(this.getClass());
    }
}



