package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.MetaLookup;
import cn.ibizlab.core.lite.filter.MetaLookupSearchContext;
import cn.ibizlab.core.lite.service.IMetaLookupService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


/**
 * 实体[lookup] 无存储服务对象接口实现
 */
@Slf4j
@Service
public class MetaLookupServiceImpl implements IMetaLookupService {


    @Override
    public boolean create(MetaLookup et) {
        //代码实现
        return true;
    }

    public void createBatch(List<MetaLookup> list){
    }

    @Override
    public boolean update(MetaLookup et) {
        //代码实现
        return true;
    }

    public void updateBatch(List<MetaLookup> list){
    }

    @Override
    public boolean remove(String key) {
        return true;
    }

    public void removeBatch(Collection<String> idList){
    }

    @Override
    public MetaLookup get(String key) {
        MetaLookup et = new MetaLookup();
        et.setId(key);
        return et;
    }

    @Override
    public MetaLookup getDraft(MetaLookup et) {
        return et;
    }

    @Override
    public boolean checkKey(MetaLookup et) {
        return false;
    }
    @Override
    @Transactional
    public boolean save(MetaLookup et) {
        //代码实现
        return true;
    }

    @Override
    public void saveBatch(List<MetaLookup> list) {
    }



	@Override
    public List<MetaLookup> selectByRelationid(String id) {
        return null;
    }

    @Override
    public void removeByRelationid(String id) {
        Set<String> delIds=new HashSet<String>();
        for(MetaLookup before:selectByRelationid(id)){
            delIds.add(before.getId());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

    public IMetaLookupService getProxyService() {
        return cn.ibizlab.util.security.SpringContextHolder.getBean(this.getClass());
    }
	@Override
    public void saveByRelationid(String id,List<MetaLookup> list) {
        if(list==null)
            return;
        Set<String> delIds=new HashSet<String>();
        List<MetaLookup> _update=new ArrayList<MetaLookup>();
        List<MetaLookup> _create=new ArrayList<MetaLookup>();
        for(MetaLookup before:selectByRelationid(id)){
            delIds.add(before.getId());
        }
        for(MetaLookup sub:list) {
            sub.setRelationid(id);
            if(ObjectUtils.isEmpty(sub.getId()))
                sub.setId((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getId())) {
                delIds.remove(sub.getId());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            getProxyService().updateBatch(_update);
        if(_create.size()>0)
            getProxyService().createBatch(_create);
        if(delIds.size()>0)
            getProxyService().removeBatch(delIds);
	}



    /**
     * 查询集合 数据集
     */
    @Override
    public Page<MetaLookup> searchDefault(MetaLookupSearchContext context) {
        return new PageImpl<MetaLookup>(new ArrayList(),context.getPageable(),0);
    }


}


