package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.DstSystem;
import cn.ibizlab.core.lite.filter.DstSystemSearchContext;
import cn.ibizlab.core.lite.service.IDstSystemService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.DstSystemMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[系统] 服务对象接口实现
 */
@Slf4j
@Service("DstSystemServiceImpl")
public class DstSystemServiceImpl extends ServiceImpl<DstSystemMapper, DstSystem> implements IDstSystemService {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IDstComponentService dstcomponentService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IDstConfigService dstconfigService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IDstRouterService dstrouterService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IDstViewService dstviewService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaEntityService metaentityService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaModelService metamodelService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaModuleService metamoduleService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(DstSystem et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getPssystemid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<DstSystem> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(DstSystem et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("pssystemid", et.getPssystemid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getPssystemid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<DstSystem> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public DstSystem get(String key) {
        DstSystem et = getById(key);
        if(et == null){
            et = new DstSystem();
            et.setPssystemid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public DstSystem getDraft(DstSystem et) {
        return et;
    }

    @Override
    public boolean checkKey(DstSystem et) {
        return (!ObjectUtils.isEmpty(et.getPssystemid())) && (!Objects.isNull(this.getById(et.getPssystemid())));
    }
    @Override
    @Transactional
    public DstSystem initDefaultDataSource(DstSystem et) {
        //自定义代码
        return et;
    }

    @Override
    @Transactional
    public boolean initDefaultDataSourceBatch(List<DstSystem> etList) {
        for(DstSystem et : etList) {
            initDefaultDataSource(et);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean save(DstSystem et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(DstSystem et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? getProxyService().update(et) : getProxyService().create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<DstSystem> list) {
        List<DstSystem> create = new ArrayList<>();
        List<DstSystem> update = new ArrayList<>();
        for (DstSystem et : list) {
            if (ObjectUtils.isEmpty(et.getPssystemid()) || ObjectUtils.isEmpty(getById(et.getPssystemid()))) {
                create.add(et);
            } else {
                update.add(et);
            }
        }
        if (create.size() > 0) {
            getProxyService().createBatch(create);
        }
        if (update.size() > 0) {
            getProxyService().updateBatch(update);
        }
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<DstSystem> list) {
        List<DstSystem> create = new ArrayList<>();
        List<DstSystem> update = new ArrayList<>();
        for (DstSystem et : list) {
            if (ObjectUtils.isEmpty(et.getPssystemid()) || ObjectUtils.isEmpty(getById(et.getPssystemid()))) {
                create.add(et);
            } else {
                update.add(et);
            }
        }
        if (create.size() > 0) {
            getProxyService().createBatch(create);
        }
        if (update.size() > 0) {
            getProxyService().updateBatch(update);
        }
    }

    @Override
    @Transactional
    public DstSystem syncSysModel(DstSystem et) {
        //自定义代码
        return et;
    }

    @Override
    @Transactional
    public boolean syncSysModelBatch(List<DstSystem> etList) {
        for(DstSystem et : etList) {
            syncSysModel(et);
        }
        return true;
    }



    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DstSystem> searchDefault(DstSystemSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<DstSystem> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<DstSystem>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }






    public IDstSystemService getProxyService() {
        return cn.ibizlab.util.security.SpringContextHolder.getBean(this.getClass());
    }
}



