package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.MetaField;
import cn.ibizlab.core.lite.filter.MetaFieldSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[MetaField] 服务对象接口
 */
public interface IMetaFieldService extends IService<MetaField> {

    boolean create(MetaField et);
    void createBatch(List<MetaField> list);
    boolean update(MetaField et);
    void updateBatch(List<MetaField> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    MetaField get(String key);
    MetaField getDraft(MetaField et);
    boolean checkKey(MetaField et);
    boolean save(MetaField et);
    void saveBatch(List<MetaField> list);
    Page<MetaField> searchDefault(MetaFieldSearchContext context);
    List<MetaField> selectByEntityId(String entity_id);
    void removeByEntityId(String entity_id);
    void saveByEntityId(String entity_id, List<MetaField> list) ;
    List<MetaField> selectByRefFieldId(String field_id);
    void removeByRefFieldId(String field_id);
    List<MetaField> selectByRelationId(String id);
    void removeByRelationId(String id);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


