package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.MetaDataSet;
import cn.ibizlab.core.lite.filter.MetaDataSetSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[MetaDataSet] 服务对象接口
 */
public interface IMetaDataSetService extends IService<MetaDataSet> {

    boolean create(MetaDataSet et);
    void createBatch(List<MetaDataSet> list);
    boolean update(MetaDataSet et);
    void updateBatch(List<MetaDataSet> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    MetaDataSet get(String key);
    MetaDataSet getDraft(MetaDataSet et);
    boolean checkKey(MetaDataSet et);
    boolean save(MetaDataSet et);
    void saveBatch(List<MetaDataSet> list);
    Page<MetaDataSet> searchDefault(MetaDataSetSearchContext context);
    List<MetaDataSet> selectByEntityId(String entity_id);
    void removeByEntityId(String entity_id);
    void saveByEntityId(String entity_id, List<MetaDataSet> list) ;
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


