package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.DstRouter;
import cn.ibizlab.core.lite.filter.DstRouterSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[DstRouter] 服务对象接口
 */
public interface IDstRouterService extends IService<DstRouter> {

    boolean create(DstRouter et);
    void createBatch(List<DstRouter> list);
    boolean update(DstRouter et);
    void updateBatch(List<DstRouter> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DstRouter get(String key);
    DstRouter getDraft(DstRouter et);
    boolean checkKey(DstRouter et);
    boolean save(DstRouter et);
    void saveBatch(List<DstRouter> list);
    Page<DstRouter> searchDefault(DstRouterSearchContext context);
    List<DstRouter> selectByAppId(String id);
    void removeByAppId(String id);
    List<DstRouter> selectByParentid(String id);
    void removeByParentid(String id);
    List<DstRouter> selectBySystemId(String pssystemid);
    void removeBySystemId(String pssystemid);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


