package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.DstDataSource;
import cn.ibizlab.core.lite.filter.DstDataSourceSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[DstDataSource] 服务对象接口
 */
@com.baomidou.dynamic.datasource.annotation.DS("db2")
public interface IDstDataSourceService extends IService<DstDataSource> {

    boolean create(DstDataSource et);
    void createBatch(List<DstDataSource> list);
    boolean update(DstDataSource et);
    void updateBatch(List<DstDataSource> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DstDataSource get(String key);
    DstDataSource getDraft(DstDataSource et);
    DstDataSource buildDS(DstDataSource et);
    boolean buildDSBatch(List<DstDataSource> etList);
    boolean checkKey(DstDataSource et);
    DstDataSource initDS(DstDataSource et);
    boolean initDSBatch(List<DstDataSource> etList);
    boolean save(DstDataSource et);
    void saveBatch(List<DstDataSource> list);
    Page<DstDataSource> searchDefault(DstDataSourceSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


