package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.DstApp;
import cn.ibizlab.core.lite.filter.DstAppSearchContext;


/**
 * 实体[DstApp] 服务对象接口
 */
public interface IDstAppService {

    boolean create(DstApp et);
    void createBatch(List<DstApp> list);
    boolean update(DstApp et);
    void updateBatch(List<DstApp> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DstApp get(String key);
    DstApp getDraft(DstApp et);
    boolean checkKey(DstApp et);
    boolean save(DstApp et);
    void saveBatch(List<DstApp> list);
    Page<DstApp> searchDefault(DstAppSearchContext context);
    List<DstApp> selectBySystemid(String pssystemid);
    void removeBySystemid(String pssystemid);

}



