package cn.ibizlab.core.lite.mapper;

import java.util.List;
import org.apache.ibatis.annotations.*;
import java.util.Map;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.HashMap;
import org.apache.ibatis.annotations.Select;
import cn.ibizlab.core.lite.domain.DstView;
import cn.ibizlab.core.lite.filter.DstViewSearchContext;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import java.io.Serializable;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.alibaba.fastjson.JSONObject;

public interface DstViewMapper extends BaseMapper<DstView> {

    Page<DstView> searchDefault(IPage page, @Param("srf") DstViewSearchContext context, @Param("ew") Wrapper<DstView> wrapper);
    @Override
    DstView selectById(Serializable id);
    @Override
    int insert(DstView entity);
    @Override
    int updateById(@Param(Constants.ENTITY) DstView entity);
    @Override
    int update(@Param(Constants.ENTITY) DstView entity, @Param("ew") Wrapper<DstView> updateWrapper);
    @Override
    int deleteById(Serializable id);
    /**
    * 自定义查询SQL
    * @param sql
    * @return
    */
    @Select("${sql}")
    List<JSONObject> selectBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义更新SQL
    * @param sql
    * @return
    */
    @Update("${sql}")
    boolean updateBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义插入SQL
    * @param sql
    * @return
    */
    @Insert("${sql}")
    boolean insertBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义删除SQL
    * @param sql
    * @return
    */
    @Delete("${sql}")
    boolean deleteBySQL(@Param("sql") String sql, @Param("et")Map param);

    List<DstView> selectByAppId(@Param("id") Serializable id);

    List<DstView> selectBySystemId(@Param("pssystemid") Serializable pssystemid);

    List<DstView> selectByEntityId(@Param("entity_id") Serializable entity_id);

}
