package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.MetaField;
/**
 * 关系型数据实体[MetaField] 查询条件对象
 */
@Slf4j
@Data
public class MetaFieldSearchContext extends QueryWrapperContext<MetaField> {

	private String n_fieldname_like;//[属性名称]
	public void setN_fieldname_like(String n_fieldname_like) {
        this.n_fieldname_like = n_fieldname_like;
        if(!ObjectUtils.isEmpty(this.n_fieldname_like)){
            this.getSearchCond().like("fieldname", n_fieldname_like);
        }
    }
	private String n_codename_like;//[代码名称]
	public void setN_codename_like(String n_codename_like) {
        this.n_codename_like = n_codename_like;
        if(!ObjectUtils.isEmpty(this.n_codename_like)){
            this.getSearchCond().like("codename", n_codename_like);
        }
    }
	private String n_entityid_eq;//[实体标识]
	public void setN_entityid_eq(String n_entityid_eq) {
        this.n_entityid_eq = n_entityid_eq;
        if(!ObjectUtils.isEmpty(this.n_entityid_eq)){
            this.getSearchCond().eq("entityid", n_entityid_eq);
        }
    }
	private String n_entityname_eq;//[实体名称]
	public void setN_entityname_eq(String n_entityname_eq) {
        this.n_entityname_eq = n_entityname_eq;
        if(!ObjectUtils.isEmpty(this.n_entityname_eq)){
            this.getSearchCond().eq("entityname", n_entityname_eq);
        }
    }
	private String n_entityname_like;//[实体名称]
	public void setN_entityname_like(String n_entityname_like) {
        this.n_entityname_like = n_entityname_like;
        if(!ObjectUtils.isEmpty(this.n_entityname_like)){
            this.getSearchCond().like("entityname", n_entityname_like);
        }
    }
	private String n_systemid_eq;//[系统]
	public void setN_systemid_eq(String n_systemid_eq) {
        this.n_systemid_eq = n_systemid_eq;
        if(!ObjectUtils.isEmpty(this.n_systemid_eq)){
            this.getSearchCond().eq("systemid", n_systemid_eq);
        }
    }
	private String n_fieldlogicname_like;//[属性逻辑名]
	public void setN_fieldlogicname_like(String n_fieldlogicname_like) {
        this.n_fieldlogicname_like = n_fieldlogicname_like;
        if(!ObjectUtils.isEmpty(this.n_fieldlogicname_like)){
            this.getSearchCond().like("fieldlogicname", n_fieldlogicname_like);
        }
    }
	private String n_reffieldid_eq;//[引用属性标识]
	public void setN_reffieldid_eq(String n_reffieldid_eq) {
        this.n_reffieldid_eq = n_reffieldid_eq;
        if(!ObjectUtils.isEmpty(this.n_reffieldid_eq)){
            this.getSearchCond().eq("reffieldid", n_reffieldid_eq);
        }
    }
	private String n_reffieldname_eq;//[引用属性名称]
	public void setN_reffieldname_eq(String n_reffieldname_eq) {
        this.n_reffieldname_eq = n_reffieldname_eq;
        if(!ObjectUtils.isEmpty(this.n_reffieldname_eq)){
            this.getSearchCond().eq("reffieldname", n_reffieldname_eq);
        }
    }
	private String n_reffieldname_like;//[引用属性名称]
	public void setN_reffieldname_like(String n_reffieldname_like) {
        this.n_reffieldname_like = n_reffieldname_like;
        if(!ObjectUtils.isEmpty(this.n_reffieldname_like)){
            this.getSearchCond().like("reffieldname", n_reffieldname_like);
        }
    }
	private String n_relationid_eq;//[引用关系标识]
	public void setN_relationid_eq(String n_relationid_eq) {
        this.n_relationid_eq = n_relationid_eq;
        if(!ObjectUtils.isEmpty(this.n_relationid_eq)){
            this.getSearchCond().eq("relationid", n_relationid_eq);
        }
    }
	private String n_relationname_eq;//[引用关系]
	public void setN_relationname_eq(String n_relationname_eq) {
        this.n_relationname_eq = n_relationname_eq;
        if(!ObjectUtils.isEmpty(this.n_relationname_eq)){
            this.getSearchCond().eq("relationname", n_relationname_eq);
        }
    }
	private String n_relationname_like;//[引用关系]
	public void setN_relationname_like(String n_relationname_like) {
        this.n_relationname_like = n_relationname_like;
        if(!ObjectUtils.isEmpty(this.n_relationname_like)){
            this.getSearchCond().like("relationname", n_relationname_like);
        }
    }
	private Integer n_keyfield_eq;//[主键]
	public void setN_keyfield_eq(Integer n_keyfield_eq) {
        this.n_keyfield_eq = n_keyfield_eq;
        if(!ObjectUtils.isEmpty(this.n_keyfield_eq)){
            this.getSearchCond().eq("keyfield", n_keyfield_eq);
        }
    }
	private Integer n_majorfield_eq;//[主信息]
	public void setN_majorfield_eq(Integer n_majorfield_eq) {
        this.n_majorfield_eq = n_majorfield_eq;
        if(!ObjectUtils.isEmpty(this.n_majorfield_eq)){
            this.getSearchCond().eq("majorfield", n_majorfield_eq);
        }
    }
	private String n_fieldtype_eq;//[属性类型]
	public void setN_fieldtype_eq(String n_fieldtype_eq) {
        this.n_fieldtype_eq = n_fieldtype_eq;
        if(!ObjectUtils.isEmpty(this.n_fieldtype_eq)){
            this.getSearchCond().eq("fieldtype", n_fieldtype_eq);
        }
    }
	private Integer n_physicalfield_eq;//[物理属性]
	public void setN_physicalfield_eq(Integer n_physicalfield_eq) {
        this.n_physicalfield_eq = n_physicalfield_eq;
        if(!ObjectUtils.isEmpty(this.n_physicalfield_eq)){
            this.getSearchCond().eq("physicalfield", n_physicalfield_eq);
        }
    }
	private String n_datatype_eq;//[数据类型]
	public void setN_datatype_eq(String n_datatype_eq) {
        this.n_datatype_eq = n_datatype_eq;
        if(!ObjectUtils.isEmpty(this.n_datatype_eq)){
            this.getSearchCond().eq("datatype", n_datatype_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("fieldname", query)
                        .or().like("fieldlogicname", query)
                        .or().like("fielduniname", query)
                        .or().like("fieldshowname", query)
            );
		 }
	}
}



