package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.MetaEntity;
/**
 * 关系型数据实体[MetaEntity] 查询条件对象
 */
@Slf4j
@Data
public class MetaEntitySearchContext extends QueryWrapperContext<MetaEntity> {

	private String n_entityname_like;//[实体名]
	public void setN_entityname_like(String n_entityname_like) {
        this.n_entityname_like = n_entityname_like;
        if(!ObjectUtils.isEmpty(this.n_entityname_like)){
            this.getSearchCond().like("entityname", n_entityname_like);
        }
    }
	private String n_logicname_like;//[逻辑名称]
	public void setN_logicname_like(String n_logicname_like) {
        this.n_logicname_like = n_logicname_like;
        if(!ObjectUtils.isEmpty(this.n_logicname_like)){
            this.getSearchCond().like("logicname", n_logicname_like);
        }
    }
	private String n_codename_eq;//[代码名称]
	public void setN_codename_eq(String n_codename_eq) {
        this.n_codename_eq = n_codename_eq;
        if(!ObjectUtils.isEmpty(this.n_codename_eq)){
            this.getSearchCond().eq("codename", n_codename_eq);
        }
    }
	private String n_tablename_like;//[表名称]
	public void setN_tablename_like(String n_tablename_like) {
        this.n_tablename_like = n_tablename_like;
        if(!ObjectUtils.isEmpty(this.n_tablename_like)){
            this.getSearchCond().like("tablename", n_tablename_like);
        }
    }
	private String n_systemid_eq;//[系统标识]
	public void setN_systemid_eq(String n_systemid_eq) {
        this.n_systemid_eq = n_systemid_eq;
        if(!ObjectUtils.isEmpty(this.n_systemid_eq)){
            this.getSearchCond().eq("systemid", n_systemid_eq);
        }
    }
	private String n_systemname_eq;//[系统]
	public void setN_systemname_eq(String n_systemname_eq) {
        this.n_systemname_eq = n_systemname_eq;
        if(!ObjectUtils.isEmpty(this.n_systemname_eq)){
            this.getSearchCond().eq("systemname", n_systemname_eq);
        }
    }
	private String n_systemname_like;//[系统]
	public void setN_systemname_like(String n_systemname_like) {
        this.n_systemname_like = n_systemname_like;
        if(!ObjectUtils.isEmpty(this.n_systemname_like)){
            this.getSearchCond().like("systemname", n_systemname_like);
        }
    }
	private String n_dsid_eq;//[数据源标识]
	public void setN_dsid_eq(String n_dsid_eq) {
        this.n_dsid_eq = n_dsid_eq;
        if(!ObjectUtils.isEmpty(this.n_dsid_eq)){
            this.getSearchCond().eq("dsid", n_dsid_eq);
        }
    }
	private String n_dsname_eq;//[数据源]
	public void setN_dsname_eq(String n_dsname_eq) {
        this.n_dsname_eq = n_dsname_eq;
        if(!ObjectUtils.isEmpty(this.n_dsname_eq)){
            this.getSearchCond().eq("dsname", n_dsname_eq);
        }
    }
	private String n_dsname_like;//[数据源]
	public void setN_dsname_like(String n_dsname_like) {
        this.n_dsname_like = n_dsname_like;
        if(!ObjectUtils.isEmpty(this.n_dsname_like)){
            this.getSearchCond().like("dsname", n_dsname_like);
        }
    }
	private String n_moduleid_eq;//[模块标识]
	public void setN_moduleid_eq(String n_moduleid_eq) {
        this.n_moduleid_eq = n_moduleid_eq;
        if(!ObjectUtils.isEmpty(this.n_moduleid_eq)){
            this.getSearchCond().eq("moduleid", n_moduleid_eq);
        }
    }
	private String n_modulename_eq;//[模块]
	public void setN_modulename_eq(String n_modulename_eq) {
        this.n_modulename_eq = n_modulename_eq;
        if(!ObjectUtils.isEmpty(this.n_modulename_eq)){
            this.getSearchCond().eq("modulename", n_modulename_eq);
        }
    }
	private String n_modulename_like;//[模块]
	public void setN_modulename_like(String n_modulename_like) {
        this.n_modulename_like = n_modulename_like;
        if(!ObjectUtils.isEmpty(this.n_modulename_like)){
            this.getSearchCond().like("modulename", n_modulename_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("entityname", query)
            );
		 }
	}
}



