package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.DstDataSource;
/**
 * 关系型数据实体[DstDataSource] 查询条件对象
 */
@Slf4j
@Data
public class DstDataSourceSearchContext extends QueryWrapperContext<DstDataSource> {

	private String n_dsname_like;//[数据源名称]
	public void setN_dsname_like(String n_dsname_like) {
        this.n_dsname_like = n_dsname_like;
        if(!ObjectUtils.isEmpty(this.n_dsname_like)){
            this.getSearchCond().like("dsname", n_dsname_like);
        }
    }
	private String n_dstype_eq;//[类型]
	public void setN_dstype_eq(String n_dstype_eq) {
        this.n_dstype_eq = n_dstype_eq;
        if(!ObjectUtils.isEmpty(this.n_dstype_eq)){
            this.getSearchCond().eq("dstype", n_dstype_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("dsname", query)
            );
		 }
	}
}



