package cn.ibizlab.core.lite.extensions.service;

import cn.ibizlab.core.lite.domain.DstApp;
import cn.ibizlab.core.lite.domain.DstSystem;
import cn.ibizlab.core.lite.extensions.domain.PermissionType;
import cn.ibizlab.core.lite.filter.DstAppSearchContext;
import cn.ibizlab.core.lite.service.IDstSystemService;
import cn.ibizlab.core.lite.service.impl.DstAppServiceImpl;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.IBZConfigService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.*;

@Primary
@Service
public class DstAppService extends DstAppServiceImpl
{

    @Autowired
    private IDstSystemService sysPSSystemService;



    @Autowired
    private LiteModelService liteModelService;



    @Override
    public DstApp get(String key)
    {
        String systemId=key.split("-")[0];
        DstSystem sysPSSystem=sysPSSystemService.getById(systemId);
        if(sysPSSystem!=null&&sysPSSystem.getApps()!=null)
        {
            for(DstApp app:sysPSSystem.getApps())
            {
                if(app.getId().equals(key))
                    return app;
            }
        }
        return null;
    }

    @Override
    public boolean save(DstApp et)
    {
        if(StringUtils.isEmpty(et.getSystemid())||StringUtils.isEmpty(et.getId()))
            throw new BadRequestAlertException("应用参数缺失","DstApp",et.getId());
        DstSystem sysPSSystem=sysPSSystemService.getById(et.getSystemid());
        if(sysPSSystem!=null&&sysPSSystem.getApps()!=null)
        {
            boolean bchange=false;
            for(DstApp app:sysPSSystem.getApps())
            {
                if(app.getId().equals(et.getId()))
                {
                    CachedBeanCopier.copy(et,app);
                    bchange=true;
                    break;
                }
            }
            sysPSSystem.set("ignoreSyncPermission",true);
            if(bchange) {
                sysPSSystemService.update(sysPSSystem);
                liteModelService.resetApps();
            }
        }
        return true;
    }

    @Override
    public boolean update(DstApp et)
    {
        return this.save(et);
    }

    @Override
    public boolean create(DstApp et)
    {
        return this.save(et);
    }

    @Override
    public Page<DstApp> searchDefault(DstAppSearchContext context)
    {
        context.setSize(Integer.MAX_VALUE);
        List<DstApp> content = new ArrayList<>();
        LinkedHashMap<String,DstApp> map = liteModelService.getApps();
        map.values().forEach(sysApp -> {
            if(!StringUtils.isEmpty(context.getN_pssystemid_eq())) {
                if(!sysApp.getSystemid().equals(context.getN_pssystemid_eq()))
                    return;
            }
            if(!StringUtils.isEmpty(context.getN_appname_like())) {
                if(sysApp.getLabel().indexOf(context.getN_appname_like())<0 &&
                        sysApp.getFullname().indexOf(context.getN_appname_like())<0)
                    return;
            }

            if(!StringUtils.isEmpty(context.getN_apptype_eq())) {
                if(context.getN_apptype_eq().equalsIgnoreCase(sysApp.getType()))
                    return;
            }
            content.add(sysApp);
        });
        return new PageImpl<DstApp>(content,context.getPageable(),content.size());
    }


    @Override
    public List<DstApp> selectBySystemid(String pssystemid) {

        DstSystem system = sysPSSystemService.getById(pssystemid);
        if (system.getSysstructure() == null)
        {
            return new ArrayList<>();
        }
        if (system.getApps() == null)
        {
            return system.getSysstructure().getSysApps(true);
        }
        return new ArrayList<>();

    }
}
