package cn.ibizlab.core.lite.extensions.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class PropertyMapping {


    @JsonIgnore
    @JSONField(serialize = false)
    private Property selfProperty;

    @JsonIgnore
    @JSONField(serialize = false)
    public DataModel getSelfDataModel()
    {
        if(this.getSelfProperty()!=null)
            return this.getSelfProperty().getOwnerDataModel();
        return null;
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public String getSelfPropertyName()
    {
        if(this.getSelfProperty()!=null)
            return this.getSelfProperty().getPropertyName();
        return "";
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public String getSelfPropertyEntity()
    {
        if(this.getSelfProperty()!=null)
            return this.getSelfProperty().getPropertyEntity();
        return "";
    }

    @JSONField(ordinal = 1)
    private String selfPropertyColumn;

    @JSONField(ordinal = 2)
    private String joinPropertyName;

    public String getJoinPropertyName()
    {
        if(StringUtils.isEmpty(joinPropertyName))
        {
            Property property=this.getSelfDataModel().getFactPorperty();
            if(property!=null)
                return property.getPropertyName();
        }
        return joinPropertyName;
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public String getJoinPropertyEntity()
    {
        if(this.getSelfDataModel()!=null)
        {
            Property property=this.getSelfDataModel().getObjectProperty(this.getJoinPropertyName());
            if(property!=null)
                return property.getPropertyEntity();
        }
        return "";
    }

    @JSONField(ordinal = 3)
    private String joinPropertyColumn;

    @Override
    public String toString() {
        return "PropertyMapping{" +
                "selfPropertyName='" + getSelfPropertyName() + '\'' +
                ", selfPropertyEntity='" + getSelfPropertyEntity() + '\'' +
                ", selfPropertyColumn='" + getSelfPropertyColumn() + '\'' +
                ", joinPropertyName='" + getJoinPropertyName() + '\'' +
                ", joinPropertyEntity='" + getJoinPropertyEntity() + '\'' +
                ", joinPropertyColumn='" + getJoinPropertyColumn() + '\'' +
                "}\r\n";
    }
}
