package cn.ibizlab.core.lite.extensions.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class LayerMapping {


    @JsonIgnore
    @JSONField(serialize = false)
    private DataModel selfDataModel;

    @JsonIgnore
    @JSONField(serialize = false)
    public String getSelfPropertyName()
    {
        if(this.getSelfDataModel()!=null)
        {
            Property property=this.getSelfDataModel().getFactPorperty();
            if(property!=null)
                return property.getPropertyName();
        }
        return "";
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public String getSelfPropertyEntity()
    {
        if(this.getSelfDataModel()!=null)
        {
            Property property=this.getSelfDataModel().getFactPorperty();
            if(property!=null)
                return property.getPropertyEntity();
        }
        return "";
    }

    @JSONField(ordinal = 1)
    private String selfPropertyColumn;

    @JsonIgnore
    @JSONField(serialize = false)
    public DataModel getParentDataModel()
    {
        if(this.getSelfDataModel()!=null)
            return this.getSelfDataModel().getParentDataModel();
        return null;
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public String getParentPropertyName()
    {
        if(this.getParentDataModel()!=null)
        {
            Property property=this.getParentDataModel().getFactPorperty();
            if(property!=null)
                return property.getPropertyName();
        }
        return "";
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public String getParentPropertyEntity()
    {
        if(this.getParentDataModel()!=null)
        {
            Property property=this.getParentDataModel().getObjectProperty(this.getParentPropertyName());
            if(property!=null)
                return property.getPropertyEntity();
        }
        return "";
    }

    @JSONField(ordinal = 2)
    private String parentPropertyColumn;

    @Override
    public String toString() {
        return "LayerMapping{" +
                "selfPropertyName='" + getSelfPropertyName() + '\'' +
                ", selfPropertyEntity='" + getSelfPropertyEntity() + '\'' +
                ", selfPropertyColumn='" + getSelfPropertyColumn() + '\'' +
                ", parentPropertyName='" + getParentPropertyName() + '\'' +
                ", parentPropertyEntity='" + getParentPropertyEntity() + '\'' +
                ", parentPropertyColumn='" + getParentPropertyColumn() + '\'' +
                "}\r\n";
    }
}
