package cn.ibizlab.core.lite.extensions.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * 实体[实体]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
public class MetaEntityModel{

    /**
     * 标识
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    private String entityId;
    /**
     * 实体名
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    private String entityName;
    /**
     * 逻辑名称
     */
    @JSONField(name = "logic_name")
    @JsonProperty("logic_name")
    private String logicName;
    /**
     * 代码名称
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    private String codeName;
    /**
     * 表名称
     */
    @JSONField(name = "table_name")
    @JsonProperty("table_name")
    private String tableName;
    /**
     * 系统标识
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 系统
     */
    @JSONField(name = "system_name")
    @JsonProperty("system_name")
    private String systemName;
    /**
     * 数据源标识
     */
    @JSONField(name = "ds_id")
    @JsonProperty("ds_id")
    private String dsId;
    /**
     * 数据源
     */
    @JSONField(name = "ds_name")
    @JsonProperty("ds_name")
    private String dsName;

    /**
     * 模块标识
     */
    @JSONField(name = "module_id")
    @JsonProperty("module_id")
    private String moduleId;
    /**
     * 模块
     */
    @JSONField(name = "module_name")
    @JsonProperty("module_name")
    private String moduleName;

    /**
     * 数据集
     */
    private List<cn.ibizlab.core.lite.domain.MetaDataSet> dataSets;

    /**
     * 属性
     */
    private List<cn.ibizlab.core.lite.domain.MetaField> fields;

    /**
     * 实体关系
     */
    private List<cn.ibizlab.core.lite.domain.MetaRelationship> parentEntitys;

    /**
     * 实体关系
     */
    private List<cn.ibizlab.core.lite.domain.MetaRelationship> subEntitys;

}


