package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[实体]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZENTITY", resultMap = "MetaEntityResultMap")
public class MetaEntity extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "entityid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    private String entityId;
    /**
     * 实体名
     */
    @TableField(value = "entityname")
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    private String entityName;
    /**
     * 逻辑名称
     */
    @TableField(value = "logicname")
    @JSONField(name = "logic_name")
    @JsonProperty("logic_name")
    private String logicName;
    /**
     * 代码名称
     */
    @TableField(value = "codename")
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    private String codeName;
    /**
     * 表名称
     */
    @TableField(value = "tablename")
    @JSONField(name = "table_name")
    @JsonProperty("table_name")
    private String tableName;
    /**
     * 系统标识
     */
    @TableField(value = "systemid")
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 系统
     */
    @TableField(exist = false)
    @JSONField(name = "system_name")
    @JsonProperty("system_name")
    private String systemName;
    /**
     * 数据源标识
     */
    @TableField(value = "dsid")
    @JSONField(name = "ds_id")
    @JsonProperty("ds_id")
    private String dsId;
    /**
     * 数据源
     */
    @TableField(exist = false)
    @JSONField(name = "ds_name")
    @JsonProperty("ds_name")
    private String dsName;
    /**
     * 模块标识
     */
    @TableField(value = "moduleid")
    @JSONField(name = "module_id")
    @JsonProperty("module_id")
    private String moduleId;
    /**
     * 模块
     */
    @TableField(exist = false)
    @JSONField(name = "module_name")
    @JsonProperty("module_name")
    private String moduleName;
    /**
     * 扩展参数
     */
    @TableField(value = "extparams")
    @JSONField(name = "ext_params")
    @JsonProperty("ext_params")
    private String extParams;
    /**
     * 排序
     */
    @TableField(value = "showorder")
    @JSONField(name = "show_order")
    @JsonProperty("show_order")
    private Integer showOrder;
    /**
     * 创建时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 最后修改时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     *
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstDataSource dataSource;

    /**
     *
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstSystem system;

    /**
     * 模型
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaModule module;


    /**
     * 数据集
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private List<cn.ibizlab.core.lite.domain.MetaDataSet> dataSets;

    /**
     * 属性
     */
//    @JsonIgnore
    @TableField(exist = false)
    private List<cn.ibizlab.core.lite.domain.MetaField> fields;

    /**
     * 实体关系
     */
//    @JsonIgnore
//    @JSONField(serialize = false)
    @TableField(exist = false)
    private List<cn.ibizlab.core.lite.domain.MetaRelationship> parentEntitys;

    /**
     * 实体关系
     */
//    @JsonIgnore
//    @JSONField(serialize = false)
    @TableField(exist = false)
    private List<cn.ibizlab.core.lite.domain.MetaRelationship> subEntitys;


    /**
     * 设置 [实体名]
     */
    public void setEntityName(String entityName) {
        this.entityName = entityName;
        this.modify("entityname", entityName);
    }

    /**
     * 设置 [逻辑名称]
     */
    public void setLogicName(String logicName) {
        this.logicName = logicName;
        this.modify("logicname", logicName);
    }

    /**
     * 设置 [代码名称]
     */
    public void setCodeName(String codeName) {
        this.codeName = codeName;
        this.modify("codename", codeName);
    }

    /**
     * 设置 [表名称]
     */
    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.modify("tablename", tableName);
    }

    /**
     * 设置 [系统标识]
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.modify("systemid", systemId);
    }

    /**
     * 设置 [数据源标识]
     */
    public void setDsId(String dsId) {
        this.dsId = dsId;
        this.modify("dsid", dsId);
    }

    /**
     * 设置 [模块标识]
     */
    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
        this.modify("moduleid", moduleId);
    }

    /**
     * 设置 [扩展参数]
     */
    public void setExtParams(String extParams) {
        this.extParams = extParams;
        this.modify("extparams", extParams);
    }

    /**
     * 设置 [排序]
     */
    public void setShowOrder(Integer showOrder) {
        this.showOrder = showOrder;
        this.modify("showorder", showOrder);
    }


    /**
     * 获取 [标识]
     */
    public String getEntityId() {
        if(ObjectUtils.isEmpty(entityId)) {
            entityId=(String)getDefaultKey(true);
        }
        return entityId;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getSystemId()))&&(!ObjectUtils.isEmpty(this.getEntityName())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s" ,this.getSystemId(),this.getEntityName()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("entityid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


