package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[动态模型配置]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZDYNAMICMODELCONFIG", resultMap = "DynamicModelConfigResultMap")
public class DynamicModelConfig extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @DEField(isKeyField = true)
    @TableId(value = "configid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "configid")
    @JsonProperty("configid")
    private String configid;
    /**
     * 名称
     */
    @TableField(value = "configname")
    @JSONField(name = "configname")
    @JsonProperty("configname")
    private String configname;
    /**
     * 文件
     */
    @TableField(value = "modelfile")
    @JSONField(name = "modelfile")
    @JsonProperty("modelfile")
    private String modelfile;
    /**
     * 状态
     */
    @TableField(value = "status")
    @JSONField(name = "status")
    @JsonProperty("status")
    private String status;



    /**
     * 设置 [名称]
     */
    public void setConfigname(String configname) {
        this.configname = configname;
        this.modify("configname", configname);
    }

    /**
     * 设置 [文件]
     */
    public void setModelfile(String modelfile) {
        this.modelfile = modelfile;
        this.modify("modelfile", modelfile);
    }

    /**
     * 设置 [状态]
     */
    public void setStatus(String status) {
        this.status = status;
        this.modify("status", status);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("configid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


