package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


/**
 * [接口] 对象
 */
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class DstAPI extends EntityBase implements Serializable {

    /**
     * 标识
     */
    @DEField(name = "apiid", isKeyField = true)
    @JSONField(name = "id")
    @JsonProperty("id")
    private String id;

    /**
     * 名称
     */
    @DEField(name = "apiname")
    @JSONField(name = "name")
    @JsonProperty("name")
    private String name;

    /**
     * 路径
     */
    @DEField(name = "apipath")
    @JSONField(name = "path")
    @JsonProperty("path")
    private String path;

    /**
     * 系统标识
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;

    /**
     * 微服务标识
     */
    @JSONField(name = "ms_id")
    @JsonProperty("ms_id")
    private String msId;

    /**
     * 微服务名称
     */
    @JSONField(name = "ms_name")
    @JsonProperty("ms_name")
    private String msName;

    /**
     * 服务名
     */
    @JSONField(name = "service_name")
    @JsonProperty("service_name")
    private String serviceName;


    /**
     * 
     */
    @JSONField(name = "microservice")
    @JsonProperty("microservice")
    private cn.ibizlab.core.lite.domain.DstMicroservice microservice;

    /**
     * 
     */
    @JSONField(name = "system")
    @JsonProperty("system")
    private cn.ibizlab.core.lite.domain.DstSystem system;



}


