package cn.ibizlab.core.extensions.service;

import cn.ibizlab.core.lite.service.IDstConfigService;
import cn.ibizlab.core.lite.service.impl.DstConfigServiceImpl;
import lombok.extern.slf4j.Slf4j;
import cn.ibizlab.core.lite.domain.DstConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Primary;
import java.util.*;

/**
 * 实体[配置] 自定义服务对象
 */
@Slf4j
@Primary
@Service("DstConfigExService")
public class DstConfigExService extends DstConfigServiceImpl {

    @Override
    protected Class currentModelClass() {
        return com.baomidou.mybatisplus.core.toolkit.ReflectionKit.getSuperClassGenericType(this.getClass().getSuperclass(), 1);
    }



    @Override
    @CacheEvict( value="ibzrt_configs",key = "'cfgid:'+#p0.cfgType+'||'+#p0.targetType+'||'+#p0.userId")
    public boolean update(DstConfig et) {
        return super.update(et);
    }

    /**
     * 自定义行为[Reset]用户扩展
     * @param et
     * @return
     */
    @Override
    @Transactional
    @CacheEvict( value="ibzrt_configs",key = "'cfgid:'+#p0.cfgType+'||'+#p0.targetType+'||'+#p0.userId")
    public DstConfig reset(DstConfig et) {
        return super.reset(et);
    }
}

