package cn.ibizlab.core.extensions.service;

import cn.ibizlab.core.lite.service.impl.DstComponentServiceImpl;
import lombok.extern.slf4j.Slf4j;
import cn.ibizlab.core.lite.domain.DstComponent;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Primary;
import java.util.*;

/**
 * 实体[组件] 自定义服务对象
 */
@Slf4j
@Primary
@Service("DstComponentExService")
public class DstComponentExService extends DstComponentServiceImpl {

    @Override
    protected Class currentModelClass() {
        return com.baomidou.mybatisplus.core.toolkit.ReflectionKit.getSuperClassGenericType(this.getClass().getSuperclass(), 1);
    }

    /**
     * 自定义行为[Sync]用户扩展
     * @param et
     * @return
     */
    @Override
    @Transactional
    public DstComponent sync(DstComponent et) {
        return super.sync(et);
    }


    @Override
    @Caching( evict = {
            @CacheEvict( value="dstcomponent",key = "'row:'+#p0.appId+'.'+#p0.name"),
            @CacheEvict( value="dstcomponent",key = "'row:'+#p0.appId+'.'+#p0.codeName")
    })
    public boolean update(DstComponent et) {

        return super.update(et);
    }
}

