package cn.ibizlab.core.avuedata.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.avuedata.domain.BladeVisual;
/**
 * 关系型数据实体[BladeVisual] 查询条件对象
 */
@Slf4j
@Data
public class BladeVisualSearchContext extends QueryWrapperContext<BladeVisual> {

	private String n_title_like;//[大屏标题]
	public void setN_title_like(String n_title_like) {
        this.n_title_like = n_title_like;
        if(!ObjectUtils.isEmpty(this.n_title_like)){
            this.getSearchCond().like("title", n_title_like);
        }
    }
	private Integer n_category_eq;//[大屏类型]
	public void setN_category_eq(Integer n_category_eq) {
        this.n_category_eq = n_category_eq;
        if(!ObjectUtils.isEmpty(this.n_category_eq)){
            this.getSearchCond().eq("category", n_category_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("title", query)
            );
		 }
	}
}



