package cn.ibizlab.core.avuedata.extensions.service;

import cn.ibizlab.core.avuedata.domain.BladeVisual;
import cn.ibizlab.core.avuedata.domain.BladeVisualConfig;
import cn.ibizlab.core.avuedata.service.IBladeVisualConfigService;
import cn.ibizlab.core.avuedata.service.impl.BladeVisualServiceImpl;
import cn.ibizlab.util.helper.CachedBeanCopier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class BladeVisualServiceImplImpl extends BladeVisualServiceImpl {

    @Autowired
    IBladeVisualConfigService iBladeVisualConfigService;
/*
    @Override
    public boolean saveOrUpdate(BladeVisual et) {
        if (null == et) {
            return false;
        } else {
            BladeVisualConfig bladeVisualConfig = new BladeVisualConfig();
            bladeVisualConfig.setComponent(et.getComponent());
            bladeVisualConfig.setDetail(et.getDetail());
            return (iBladeVisualConfigService.save(bladeVisualConfig) && checkKey(et) ? this.update(et) : this.create(et));
        }
    }*/

    @Override
    public boolean create(BladeVisual et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        BladeVisualConfig bladeVisualConfig = new BladeVisualConfig();
        bladeVisualConfig.setComponent(et.getComponent());
        bladeVisualConfig.setDetail(et.getDetail());
        bladeVisualConfig.setId(et.getId());
        bladeVisualConfig.setVisualid(et.getId());
        CachedBeanCopier.copy(get(et.getId()), et);
        iBladeVisualConfigService.create(bladeVisualConfig);
        return true;
    }

    @Override
    public BladeVisual get(Long key) {
        BladeVisual et = getById(key);
        if(et == null){
            et = new BladeVisual();
            et.setId(key);
        }
        else {
            BladeVisualConfig bladeVisualConfig =iBladeVisualConfigService.get(key);
            et.setComponent(bladeVisualConfig.getComponent());
            et.setDetail(bladeVisualConfig.getDetail());
        }
        return et;
    }

}
