import Vue from 'vue'
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import axios from 'axios';
import router from './router.js';
import App from './App.vue'
import './styles/common.scss'
import { url } from '@/config'
import '@/mock/'
//注册自定义组件
import './components/'
//导入主题文件
import '@/theme/index.js'
axios.interceptors.request.use((config) => {
  let appdata;
  if (appdata && appdata.context) {
      config.headers['srforgsectorid'] = appdata.context.srforgsectorid;
  }
  if(!window.localStorage.getItem('token')){
      let arr;
      let reg = new RegExp("(^| )ibzuaa-token=([^;]*)(;|$)");
      if (arr = document.cookie.match(reg)){
          window.localStorage.setItem('token',unescape(arr[2]));
      }
  }
  if (window.localStorage.getItem('token')) {
      const token = window.localStorage.getItem('token');
      config.headers['Authorization'] = `Bearer ${token}`;
  }else{
      config.headers['Authorization'] = 'Bearer eyJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJpYnphZG1pbiIsImV4cCI6MTYwNTc1NzM1OCwiaWF0IjoxNjA1NzUwMTU4fQ.o3wK61IYekbSAcZ37pdbpaHU2vLLybHySG0M0cGuktkHlA3ozgDmFOYtlBVQ-D14MWm9qWZNvaXNs3R4x3v0JkgBpTwa_ksocGaOZkc7IXvyDUW6qvObDL0BXq6QR47MinxMLuS1KyJiO2FuzXGC7GUERmTdLJKR6fDwWaps-Q0';
  }
  return config;
}, (error) => {
  return Promise.reject(error);
});
window.axios = axios;
Vue.config.productionTip = false
Vue.prototype.url = url;
Vue.use(window.AVUE, {
  size: 'mini'
});
Vue.use(ElementUI);
new Vue({
  router,
  render: h => h(App)
}).$mount('#app')
