import { url } from '@/config';
var request = window.axios;
/* export const getList = (params) => request({
  url: url + '/visual/list',
  method: 'get',
  params: params
}); */
export const getList = (params) => {
  let newparams = {
    page: params.current - 1,
    size: params.size,
    n_category_eq: params.category
  };
  return new Promise((resolve, reject) => {
    request({
      url: url + '/bladevisuals/searchdefault',
      method: 'post',
      data: JSON.stringify(newparams),
      headers: { 'Content-Type': 'application/json;charset=UTF-8', 'Accept': 'application/json' }
    }).then((response) => {
      let data = {};
      response = response.data;
      data.records = response.content;
      data.size = response.size;
      data.total = response.totalElements;
      data.current = response.number + 1;
      data.pages = response.totalPages;
      resolve({data:{data:data}});
    }).catch((response) => {
      reject(response);
    });
  });
}



export const copyObj = (id) => request({
  url: url + '/visual/copy',
  method: 'post',
  params: {
    id: id
  }
});

/* export const getCategory = (params) => request({
  url: url + '/category/list',
  method: 'get',
  params: params
}); */

export const getCategory = (params) => {
  return request({
    url: url + '/bladevisualcategories/fetchdefault',
    method: 'get',
    params: params
  });
}
/* export const getObj = (id) => request({
  url: url + '/visual/detail',
  method: 'get',
  params: {
    id
  }
}); */
export const getObj = (id) => {
  return new Promise((resolve, reject) => {
    request({
      url: url + `/bladevisuals/${id}`,
      method: 'get'
    }).then((response) => {
      let config = {
        component: response.data.component,
        detail: response.data.detail
      };
      delete response.data.component;
      delete response.data.detail;
      let visual = response.data;
      resolve({ data: {data: { visual: visual, config: config } } });
    }).catch((response) => {
      reject(response);
    });
  })
}
export const uploadImg = (file) => request({
  url: url + '/visual/put-file',
  method: 'post',
  data: 'file=' + file,
  headers: { "Content-Type": "multipart/form-data" }
});

export const addObj = (data) => {
  return new Promise((resolve, reject) => {
    if(!data.status){
      data.status = 1;
    }
    request({
      url: url + '/bladevisuals',
      method: 'post',
      data: {
          password: data.password,
          category: data.category,
          status: data.status,
          title: data.title,
          detail: JSON.stringify({
            name: data.title,
            width: data.width,
            height: data.height,
            scale: 1,
            backgroundImage: '/img/bg/bg1.png',
            url: '',
            mark: {},
            gradeShow: false,
            gradeLen: 30,
            }),
            component: '[]'
      }
    }).then((response) => {
      let res = {};
      if(response){
        res.code = 200;
        res.msg = "操作成功!";
        res.success = response;
        res.data = {id: response.data.id};
      }
      resolve({data: res});
    }).catch((response) => {
      reject(response);
    });
  })
}

export const updateComponent = (data) => request({
  url: url + '/visual/update',
  method: 'post',
  data: data
});

export const updateObj = (data) => request({
  url: url + '/visual/update',
  method: 'post',
  data: {
    "visual": {
      "id": data.id,
      "password": data.password,
      "category": data.category,
      "status": data.status,
      "title": data.title,
    }
  }
});

export const delObj = (id) => request({
  url: url + '/visual/remove',
  method: 'post',
  params: {
    ids: id
  }
});