import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 属性服务对象基类
 *
 * @export
 * @class MetaFieldServiceBase
 * @extends {EntityServie}
 */
export default class MetaFieldServiceBase extends EntityService {

    /**
     * Creates an instance of  MetaFieldServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  MetaFieldServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof MetaFieldServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='metafield';
        this.APPDEKEY = 'field_id';
        this.APPDENAME = 'metafields';
        this.APPDETEXT = 'field_name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metafield){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/${context.metafield}/select`,isloading);
            
            return res;
        }
        if(context.metaentity && context.metafield){
            let res:any = Http.getInstance().get(`/metaentities/${context.metaentity}/metafields/${context.metafield}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/metafields/${context.metafield}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields`,data,isloading);
            
            return res;
        }
        if(context.metaentity && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metafields`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/metafields`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metafield){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/${context.metafield}`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metafield){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/metaentities/${context.metaentity}/metafields/${context.metafield}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/metafields/${context.metafield}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metafield){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/${context.metafield}`,isloading);
            return res;
        }
        if(context.metaentity && context.metafield){
            let res:any = Http.getInstance().delete(`/metaentities/${context.metaentity}/metafields/${context.metafield}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/metafields/${context.metafield}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metafield){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/${context.metafield}`,isloading);
            
            return res;
        }
        if(context.metaentity && context.metafield){
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}/metafields/${context.metafield}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/metafields/${context.metafield}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/getdraft`,isloading);
            res.data.metafield = data.metafield;
            
            return res;
        }
        if(context.metaentity && true){
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}/metafields/getdraft`,isloading);
            res.data.metafield = data.metafield;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/metafields/getdraft`,isloading);
        res.data.metafield = data.metafield;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metafield){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/${context.metafield}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metafield){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metafields/${context.metafield}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/metafields/${context.metafield}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metafield){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/${context.metafield}/save`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metafield){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metafields/${context.metafield}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/metafields/${context.metafield}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/metaentities/${context.metaentity}/metafields/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/metafields/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaFieldServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metafields/searchdefault`,tempData,isloading);
        }
        if(context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/metaentities/${context.metaentity}/metafields/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/metafields/searchdefault`,tempData,isloading);
    }
}