import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 实体服务对象基类
 *
 * @export
 * @class MetaEntityServiceBase
 * @extends {EntityServie}
 */
export default class MetaEntityServiceBase extends EntityService {

    /**
     * Creates an instance of  MetaEntityServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  MetaEntityServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof MetaEntityServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='metaentity';
        this.APPDEKEY = 'entity_id';
        this.APPDENAME = 'metaentities';
        this.APPDETEXT = 'entity_name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/metaentities/${context.metaentity}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_metadatasets',JSON.stringify(res.data.metadatasets?res.data.metadatasets:[]));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_metafields',JSON.stringify(res.data.metafields?res.data.metafields:[]));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_metarelationships',JSON.stringify(res.data.metarelationships?res.data.metarelationships:[]));
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/metaentities`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_metadatasets',JSON.stringify(res.data.metadatasets?res.data.metadatasets:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_metafields',JSON.stringify(res.data.metafields?res.data.metafields:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_metarelationships',JSON.stringify(res.data.metarelationships?res.data.metarelationships:[]));
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/metaentities/${context.metaentity}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/metaentities/${context.metaentity}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/getdraft`,isloading);
            res.data.metaentity = data.metaentity;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/metaentities/getdraft`,isloading);
        res.data.metaentity = data.metaentity;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/metaentities/${context.metaentity}/checkkey`,data,isloading);
            return res;
    }

    /**
     * GetDefaultModel接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async GetDefaultModel(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/getdefaultmodel`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}/getdefaultmodel`,isloading);
            
            return res;
    }

    /**
     * GetDefaultModelBatch接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async GetDefaultModelBatch(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/getdefaultmodelbatch`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/metaentities/getdefaultmodelbatch`,tempData,isloading);
    }

    /**
     * InitModels接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async InitModels(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/initmodels`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/metaentities/${context.metaentity}/initmodels`,data,isloading);
            return res;
    }

    /**
     * InitModelsBatch接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async InitModelsBatch(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/initmodelsbatch`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/metaentities/initmodelsbatch`,tempData,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/metaentities/${context.metaentity}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/metaentities/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaEntityServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/metaentities/searchdefault`,tempData,isloading);
    }
}