/**
 * 实体数据服务注册中心
 *
 * @export
 * @class EntityServiceRegister
 */
export class EntityServiceRegister {

    /**
     * 所有实体数据服务Map
     *
     * @protected
     * @type {*}
     * @memberof EntityServiceRegister
     */
    protected allEntityService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载实体数据服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof EntityServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of EntityServiceRegister.
     * @memberof EntityServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof EntityServiceRegister
     */
    protected init(): void {
                this.allEntityService.set('dstmicroservice', () => import('@/service/dst-microservice/dst-microservice-service'));
        this.allEntityService.set('metafield', () => import('@/service/meta-field/meta-field-service'));
        this.allEntityService.set('dstapp', () => import('@/service/dst-app/dst-app-service'));
        this.allEntityService.set('dstcomponent', () => import('@/service/dst-component/dst-component-service'));
        this.allEntityService.set('metadataset', () => import('@/service/meta-data-set/meta-data-set-service'));
        this.allEntityService.set('dstview', () => import('@/service/dst-view/dst-view-service'));
        this.allEntityService.set('dstapi', () => import('@/service/dst-api/dst-api-service'));
        this.allEntityService.set('dstrouter', () => import('@/service/dst-router/dst-router-service'));
        this.allEntityService.set('dstconfig', () => import('@/service/dst-config/dst-config-service'));
        this.allEntityService.set('dynamicmodelconfig', () => import('@/service/dynamic-model-config/dynamic-model-config-service'));
        this.allEntityService.set('metamodel', () => import('@/service/meta-model/meta-model-service'));
        this.allEntityService.set('metamodule', () => import('@/service/meta-module/meta-module-service'));
        this.allEntityService.set('dstdatasource', () => import('@/service/dst-data-source/dst-data-source-service'));
        this.allEntityService.set('dstsystem', () => import('@/service/dst-system/dst-system-service'));
        this.allEntityService.set('metarelationship', () => import('@/service/meta-relationship/meta-relationship-service'));
        this.allEntityService.set('bladevisual', () => import('@/service/blade-visual/blade-visual-service'));
        this.allEntityService.set('metaentity', () => import('@/service/meta-entity/meta-entity-service'));
    }

    /**
     * 加载实体数据服务
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof EntityServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allEntityService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体数据服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof EntityServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const entityService: any = await this.loadService(name);
        if (entityService && entityService.default) {
            const instance: any = new entityService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const entityServiceRegister: EntityServiceRegister = new EntityServiceRegister();