import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 路由服务对象基类
 *
 * @export
 * @class DstRouterServiceBase
 * @extends {EntityServie}
 */
export default class DstRouterServiceBase extends EntityService {

    /**
     * Creates an instance of  DstRouterServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DstRouterServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof DstRouterServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='dstrouter';
        this.APPDEKEY = 'id';
        this.APPDENAME = 'dstrouters';
        this.APPDETEXT = 'name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstrouter){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}/select`,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstrouter){
            let res:any = Http.getInstance().get(`/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/dstrouters/${context.dstrouter}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters`,data,isloading);
            
            return res;
        }
        if(context.dstapp && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstrouters`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/dstrouters`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstrouter){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstrouter){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/dstrouters/${context.dstrouter}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstrouter){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}`,isloading);
            return res;
        }
        if(context.dstapp && context.dstrouter){
            let res:any = Http.getInstance().delete(`/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/dstrouters/${context.dstrouter}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstrouter){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}`,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstrouter){
            let res:any = await Http.getInstance().get(`/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/dstrouters/${context.dstrouter}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/getdraft`,isloading);
            res.data.dstrouter = data.dstrouter;
            
            return res;
        }
        if(context.dstapp && true){
            let res:any = await Http.getInstance().get(`/dstapps/${context.dstapp}/dstrouters/getdraft`,isloading);
            res.data.dstrouter = data.dstrouter;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/dstrouters/getdraft`,isloading);
        res.data.dstrouter = data.dstrouter;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstrouter){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstrouter){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/dstrouters/${context.dstrouter}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstrouter){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}/save`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstrouter){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstrouters/${context.dstrouter}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/dstrouters/${context.dstrouter}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstapps/${context.dstapp}/dstrouters/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/dstrouters/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstRouterServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstrouters/searchdefault`,tempData,isloading);
        }
        if(context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstapps/${context.dstapp}/dstrouters/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/dstrouters/searchdefault`,tempData,isloading);
    }
}