import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 微服务服务对象基类
 *
 * @export
 * @class DstMicroserviceServiceBase
 * @extends {EntityServie}
 */
export default class DstMicroserviceServiceBase extends EntityService {

    /**
     * Creates an instance of  DstMicroserviceServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DstMicroserviceServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof DstMicroserviceServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='dstmicroservice';
        this.APPDEKEY = 'id';
        this.APPDENAME = 'dstmicroservices';
        this.APPDETEXT = 'label';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/dstmicroservices/${context.dstmicroservice}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstmicroservices`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_dstapis',JSON.stringify(res.data.dstapis?res.data.dstapis:[]));
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/dstmicroservices`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_dstapis',JSON.stringify(res.data.dstapis?res.data.dstapis:[]));
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/dstmicroservices/${context.dstmicroservice}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/dstmicroservices/${context.dstmicroservice}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/dstmicroservices/${context.dstmicroservice}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/getdraft`,isloading);
            res.data.dstmicroservice = data.dstmicroservice;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/dstmicroservices/getdraft`,isloading);
        res.data.dstmicroservice = data.dstmicroservice;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/dstmicroservices/${context.dstmicroservice}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/dstmicroservices/${context.dstmicroservice}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/dstmicroservices/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstMicroserviceServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstmicroservices/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/dstmicroservices/searchdefault`,tempData,isloading);
    }
}