import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 应用服务对象基类
 *
 * @export
 * @class DstAppServiceBase
 * @extends {EntityServie}
 */
export default class DstAppServiceBase extends EntityService {

    /**
     * Creates an instance of  DstAppServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DstAppServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof DstAppServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='dstapp';
        this.APPDEKEY = 'id';
        this.APPDENAME = 'dstapps';
        this.APPDETEXT = 'label';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/dstapps/${context.dstapp}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_dstcomponents',JSON.stringify(res.data.dstcomponents?res.data.dstcomponents:[]));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_dstrouters',JSON.stringify(res.data.dstrouters?res.data.dstrouters:[]));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_dstviews',JSON.stringify(res.data.dstviews?res.data.dstviews:[]));
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/dstapps`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_dstcomponents',JSON.stringify(res.data.dstcomponents?res.data.dstcomponents:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_dstrouters',JSON.stringify(res.data.dstrouters?res.data.dstrouters:[]));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_dstviews',JSON.stringify(res.data.dstviews?res.data.dstviews:[]));
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/dstapps/${context.dstapp}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/dstapps/${context.dstapp}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/dstapps/${context.dstapp}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/getdraft`,isloading);
            res.data.dstapp = data.dstapp;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/dstapps/getdraft`,isloading);
        res.data.dstapp = data.dstapp;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/dstapps/${context.dstapp}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/dstapps/${context.dstapp}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/dstapps/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAppServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/dstapps/searchdefault`,tempData,isloading);
    }
}