/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'systemid',
          prop: 'system_id',
          dataType: 'PICKUP',
        },
        {
          name: 'component',
          prop: 'component',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'routerpath',
          prop: 'path',
          dataType: 'TEXT',
        },
        {
          name: 'routername',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'appid',
          prop: 'app_id',
          dataType: 'PICKUP',
        },
        {
          name: 'parentid',
          prop: 'parentid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'id',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'dstrouter',
          prop: 'id',
        },
      {
        name: 'n_routername_like',
        prop: 'n_routername_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_routerpath_like',
        prop: 'n_routerpath_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_appid_eq',
        prop: 'n_appid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}