package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.DstRouter;
import cn.ibizlab.core.lite.service.IDstRouterService;
import cn.ibizlab.core.lite.filter.DstRouterSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"路由" })
@RestController("api-dstrouter")
@RequestMapping("")
public class DstRouterResource {

    @Autowired
    public IDstRouterService dstrouterService;

    @Autowired
    @Lazy
    public DstRouterMapping dstrouterMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Create-all')")
    @ApiOperation(value = "新建路由", tags = {"路由" },  notes = "新建路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstrouters")
    public ResponseEntity<DstRouterDTO> create(@Validated @RequestBody DstRouterDTO dstrouterdto) {
        DstRouter domain = dstrouterMapping.toDomain(dstrouterdto);
		dstrouterService.create(domain);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Create-all')")
    @ApiOperation(value = "批量新建路由", tags = {"路由" },  notes = "批量新建路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstrouters/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DstRouterDTO> dstrouterdtos) {
        dstrouterService.createBatch(dstrouterMapping.toDomain(dstrouterdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Update-all')")
    @ApiOperation(value = "更新路由", tags = {"路由" },  notes = "更新路由")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstrouters/{dstrouter_id}")
    public ResponseEntity<DstRouterDTO> update(@PathVariable("dstrouter_id") String dstrouter_id, @RequestBody DstRouterDTO dstrouterdto) {
		DstRouter domain  = dstrouterMapping.toDomain(dstrouterdto);
        domain .setId(dstrouter_id);
		dstrouterService.update(domain );
		DstRouterDTO dto = dstrouterMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Update-all')")
    @ApiOperation(value = "批量更新路由", tags = {"路由" },  notes = "批量更新路由")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstrouters/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DstRouterDTO> dstrouterdtos) {
        dstrouterService.updateBatch(dstrouterMapping.toDomain(dstrouterdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Remove-all')")
    @ApiOperation(value = "删除路由", tags = {"路由" },  notes = "删除路由")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstrouters/{dstrouter_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("dstrouter_id") String dstrouter_id) {
         return ResponseEntity.status(HttpStatus.OK).body(dstrouterService.remove(dstrouter_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Remove-all')")
    @ApiOperation(value = "批量删除路由", tags = {"路由" },  notes = "批量删除路由")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstrouters/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        dstrouterService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Get-all')")
    @ApiOperation(value = "获取路由", tags = {"路由" },  notes = "获取路由")
	@RequestMapping(method = RequestMethod.GET, value = "/dstrouters/{dstrouter_id}")
    public ResponseEntity<DstRouterDTO> get(@PathVariable("dstrouter_id") String dstrouter_id) {
        DstRouter domain = dstrouterService.get(dstrouter_id);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取路由草稿", tags = {"路由" },  notes = "获取路由草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/dstrouters/getdraft")
    public ResponseEntity<DstRouterDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(dstrouterMapping.toDto(dstrouterService.getDraft(new DstRouter())));
    }

    @ApiOperation(value = "检查路由", tags = {"路由" },  notes = "检查路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstrouters/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DstRouterDTO dstrouterdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstrouterService.checkKey(dstrouterMapping.toDomain(dstrouterdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Save-all')")
    @ApiOperation(value = "保存路由", tags = {"路由" },  notes = "保存路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstrouters/save")
    public ResponseEntity<Boolean> save(@RequestBody DstRouterDTO dstrouterdto) {
        return ResponseEntity.status(HttpStatus.OK).body(dstrouterService.save(dstrouterMapping.toDomain(dstrouterdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Save-all')")
    @ApiOperation(value = "批量保存路由", tags = {"路由" },  notes = "批量保存路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstrouters/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DstRouterDTO> dstrouterdtos) {
        dstrouterService.saveBatch(dstrouterMapping.toDomain(dstrouterdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"路由" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstrouters/fetchdefault")
	public ResponseEntity<List<DstRouterDTO>> fetchDefault(DstRouterSearchContext context) {
        Page<DstRouter> domains = dstrouterService.searchDefault(context) ;
        List<DstRouterDTO> list = dstrouterMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"路由" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstrouters/searchdefault")
	public ResponseEntity<Page<DstRouterDTO>> searchDefault(@RequestBody DstRouterSearchContext context) {
        Page<DstRouter> domains = dstrouterService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstrouterMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Create-all')")
    @ApiOperation(value = "根据应用建立路由", tags = {"路由" },  notes = "根据应用建立路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstrouters")
    public ResponseEntity<DstRouterDTO> createByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterDTO dstrouterdto) {
        DstRouter domain = dstrouterMapping.toDomain(dstrouterdto);
        domain.setAppId(dstapp_id);
		dstrouterService.create(domain);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Create-all')")
    @ApiOperation(value = "根据应用批量建立路由", tags = {"路由" },  notes = "根据应用批量建立路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstrouters/batch")
    public ResponseEntity<Boolean> createBatchByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstRouterDTO> dstrouterdtos) {
        List<DstRouter> domainlist=dstrouterMapping.toDomain(dstrouterdtos);
        for(DstRouter domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstrouterService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Update-all')")
    @ApiOperation(value = "根据应用更新路由", tags = {"路由" },  notes = "根据应用更新路由")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstapps/{dstapp_id}/dstrouters/{dstrouter_id}")
    public ResponseEntity<DstRouterDTO> updateByDstApp(@PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstrouter_id") String dstrouter_id, @RequestBody DstRouterDTO dstrouterdto) {
        DstRouter domain = dstrouterMapping.toDomain(dstrouterdto);
        domain.setAppId(dstapp_id);
        domain.setId(dstrouter_id);
		dstrouterService.update(domain);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Update-all')")
    @ApiOperation(value = "根据应用批量更新路由", tags = {"路由" },  notes = "根据应用批量更新路由")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstapps/{dstapp_id}/dstrouters/batch")
    public ResponseEntity<Boolean> updateBatchByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstRouterDTO> dstrouterdtos) {
        List<DstRouter> domainlist=dstrouterMapping.toDomain(dstrouterdtos);
        for(DstRouter domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstrouterService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Remove-all')")
    @ApiOperation(value = "根据应用删除路由", tags = {"路由" },  notes = "根据应用删除路由")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstapps/{dstapp_id}/dstrouters/{dstrouter_id}")
    public ResponseEntity<Boolean> removeByDstApp(@PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstrouter_id") String dstrouter_id) {
		return ResponseEntity.status(HttpStatus.OK).body(dstrouterService.remove(dstrouter_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Remove-all')")
    @ApiOperation(value = "根据应用批量删除路由", tags = {"路由" },  notes = "根据应用批量删除路由")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstapps/{dstapp_id}/dstrouters/batch")
    public ResponseEntity<Boolean> removeBatchByDstApp(@RequestBody List<String> ids) {
        dstrouterService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Get-all')")
    @ApiOperation(value = "根据应用获取路由", tags = {"路由" },  notes = "根据应用获取路由")
	@RequestMapping(method = RequestMethod.GET, value = "/dstapps/{dstapp_id}/dstrouters/{dstrouter_id}")
    public ResponseEntity<DstRouterDTO> getByDstApp(@PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstrouter_id") String dstrouter_id) {
        DstRouter domain = dstrouterService.get(dstrouter_id);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据应用获取路由草稿", tags = {"路由" },  notes = "根据应用获取路由草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstapps/{dstapp_id}/dstrouters/getdraft")
    public ResponseEntity<DstRouterDTO> getDraftByDstApp(@PathVariable("dstapp_id") String dstapp_id) {
        DstRouter domain = new DstRouter();
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstrouterMapping.toDto(dstrouterService.getDraft(domain)));
    }

    @ApiOperation(value = "根据应用检查路由", tags = {"路由" },  notes = "根据应用检查路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstrouters/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterDTO dstrouterdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstrouterService.checkKey(dstrouterMapping.toDomain(dstrouterdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Save-all')")
    @ApiOperation(value = "根据应用保存路由", tags = {"路由" },  notes = "根据应用保存路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstrouters/save")
    public ResponseEntity<Boolean> saveByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterDTO dstrouterdto) {
        DstRouter domain = dstrouterMapping.toDomain(dstrouterdto);
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstrouterService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Save-all')")
    @ApiOperation(value = "根据应用批量保存路由", tags = {"路由" },  notes = "根据应用批量保存路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstrouters/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstRouterDTO> dstrouterdtos) {
        List<DstRouter> domainlist=dstrouterMapping.toDomain(dstrouterdtos);
        for(DstRouter domain:domainlist){
             domain.setAppId(dstapp_id);
        }
        dstrouterService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-searchDefault-all')")
	@ApiOperation(value = "根据应用获取数据集", tags = {"路由" } ,notes = "根据应用获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstapps/{dstapp_id}/dstrouters/fetchdefault")
	public ResponseEntity<List<DstRouterDTO>> fetchDstRouterDefaultByDstApp(@PathVariable("dstapp_id") String dstapp_id,DstRouterSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstRouter> domains = dstrouterService.searchDefault(context) ;
        List<DstRouterDTO> list = dstrouterMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-searchDefault-all')")
	@ApiOperation(value = "根据应用查询数据集", tags = {"路由" } ,notes = "根据应用查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstapps/{dstapp_id}/dstrouters/searchdefault")
	public ResponseEntity<Page<DstRouterDTO>> searchDstRouterDefaultByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstRouter> domains = dstrouterService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstrouterMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Create-all')")
    @ApiOperation(value = "根据系统应用建立路由", tags = {"路由" },  notes = "根据系统应用建立路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters")
    public ResponseEntity<DstRouterDTO> createByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterDTO dstrouterdto) {
        DstRouter domain = dstrouterMapping.toDomain(dstrouterdto);
        domain.setAppId(dstapp_id);
		dstrouterService.create(domain);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Create-all')")
    @ApiOperation(value = "根据系统应用批量建立路由", tags = {"路由" },  notes = "根据系统应用批量建立路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/batch")
    public ResponseEntity<Boolean> createBatchByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstRouterDTO> dstrouterdtos) {
        List<DstRouter> domainlist=dstrouterMapping.toDomain(dstrouterdtos);
        for(DstRouter domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstrouterService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Update-all')")
    @ApiOperation(value = "根据系统应用更新路由", tags = {"路由" },  notes = "根据系统应用更新路由")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/{dstrouter_id}")
    public ResponseEntity<DstRouterDTO> updateByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstrouter_id") String dstrouter_id, @RequestBody DstRouterDTO dstrouterdto) {
        DstRouter domain = dstrouterMapping.toDomain(dstrouterdto);
        domain.setAppId(dstapp_id);
        domain.setId(dstrouter_id);
		dstrouterService.update(domain);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Update-all')")
    @ApiOperation(value = "根据系统应用批量更新路由", tags = {"路由" },  notes = "根据系统应用批量更新路由")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/batch")
    public ResponseEntity<Boolean> updateBatchByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstRouterDTO> dstrouterdtos) {
        List<DstRouter> domainlist=dstrouterMapping.toDomain(dstrouterdtos);
        for(DstRouter domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstrouterService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Remove-all')")
    @ApiOperation(value = "根据系统应用删除路由", tags = {"路由" },  notes = "根据系统应用删除路由")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/{dstrouter_id}")
    public ResponseEntity<Boolean> removeByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstrouter_id") String dstrouter_id) {
		return ResponseEntity.status(HttpStatus.OK).body(dstrouterService.remove(dstrouter_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Remove-all')")
    @ApiOperation(value = "根据系统应用批量删除路由", tags = {"路由" },  notes = "根据系统应用批量删除路由")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/batch")
    public ResponseEntity<Boolean> removeBatchByDstSystemDstApp(@RequestBody List<String> ids) {
        dstrouterService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Get-all')")
    @ApiOperation(value = "根据系统应用获取路由", tags = {"路由" },  notes = "根据系统应用获取路由")
	@RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/{dstrouter_id}")
    public ResponseEntity<DstRouterDTO> getByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstrouter_id") String dstrouter_id) {
        DstRouter domain = dstrouterService.get(dstrouter_id);
        DstRouterDTO dto = dstrouterMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统应用获取路由草稿", tags = {"路由" },  notes = "根据系统应用获取路由草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/getdraft")
    public ResponseEntity<DstRouterDTO> getDraftByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id) {
        DstRouter domain = new DstRouter();
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstrouterMapping.toDto(dstrouterService.getDraft(domain)));
    }

    @ApiOperation(value = "根据系统应用检查路由", tags = {"路由" },  notes = "根据系统应用检查路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterDTO dstrouterdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstrouterService.checkKey(dstrouterMapping.toDomain(dstrouterdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Save-all')")
    @ApiOperation(value = "根据系统应用保存路由", tags = {"路由" },  notes = "根据系统应用保存路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/save")
    public ResponseEntity<Boolean> saveByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterDTO dstrouterdto) {
        DstRouter domain = dstrouterMapping.toDomain(dstrouterdto);
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstrouterService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-Save-all')")
    @ApiOperation(value = "根据系统应用批量保存路由", tags = {"路由" },  notes = "根据系统应用批量保存路由")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstRouterDTO> dstrouterdtos) {
        List<DstRouter> domainlist=dstrouterMapping.toDomain(dstrouterdtos);
        for(DstRouter domain:domainlist){
             domain.setAppId(dstapp_id);
        }
        dstrouterService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-searchDefault-all')")
	@ApiOperation(value = "根据系统应用获取数据集", tags = {"路由" } ,notes = "根据系统应用获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/fetchdefault")
	public ResponseEntity<List<DstRouterDTO>> fetchDstRouterDefaultByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id,DstRouterSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstRouter> domains = dstrouterService.searchDefault(context) ;
        List<DstRouterDTO> list = dstrouterMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstRouter-searchDefault-all')")
	@ApiOperation(value = "根据系统应用查询数据集", tags = {"路由" } ,notes = "根据系统应用查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstrouters/searchdefault")
	public ResponseEntity<Page<DstRouterDTO>> searchDstRouterDefaultByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstRouterSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstRouter> domains = dstrouterService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstrouterMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

