/**
 * UI服务注册中心
 *
 * @export
 * @class UIServiceRegister
 */
export class UIServiceRegister {

    /**
     * 所有UI实体服务Map
     *
     * @protected
     * @type {*}
     * @memberof UIServiceRegister
     */
    protected allUIService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载UI实体服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof UIServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of UIServiceRegister.
     * @memberof UIServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UIServiceRegister
     */
    protected init(): void {
                this.allUIService.set('dstmicroservice', () => import('@/uiservice/dst-microservice/dst-microservice-ui-service'));
        this.allUIService.set('metafield', () => import('@/uiservice/meta-field/meta-field-ui-service'));
        this.allUIService.set('dstapp', () => import('@/uiservice/dst-app/dst-app-ui-service'));
        this.allUIService.set('dstcomponent', () => import('@/uiservice/dst-component/dst-component-ui-service'));
        this.allUIService.set('metadataset', () => import('@/uiservice/meta-data-set/meta-data-set-ui-service'));
        this.allUIService.set('dstview', () => import('@/uiservice/dst-view/dst-view-ui-service'));
        this.allUIService.set('dstapi', () => import('@/uiservice/dst-api/dst-api-ui-service'));
        this.allUIService.set('dstrouter', () => import('@/uiservice/dst-router/dst-router-ui-service'));
        this.allUIService.set('dstconfig', () => import('@/uiservice/dst-config/dst-config-ui-service'));
        this.allUIService.set('dynamicmodelconfig', () => import('@/uiservice/dynamic-model-config/dynamic-model-config-ui-service'));
        this.allUIService.set('metamodel', () => import('@/uiservice/meta-model/meta-model-ui-service'));
        this.allUIService.set('metamodule', () => import('@/uiservice/meta-module/meta-module-ui-service'));
        this.allUIService.set('dstdatasource', () => import('@/uiservice/dst-data-source/dst-data-source-ui-service'));
        this.allUIService.set('dstsystem', () => import('@/uiservice/dst-system/dst-system-ui-service'));
        this.allUIService.set('metarelationship', () => import('@/uiservice/meta-relationship/meta-relationship-ui-service'));
        this.allUIService.set('bladevisual', () => import('@/uiservice/blade-visual/blade-visual-ui-service'));
        this.allUIService.set('metaentity', () => import('@/uiservice/meta-entity/meta-entity-ui-service'));
    }

    /**
     * 加载服务实体
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allUIService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const entityService: any = await this.loadService(name);
        if (entityService && entityService.default) {
            const instance: any = new entityService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const uiServiceRegister: UIServiceRegister = new UIServiceRegister();