package liquibase.integration.spring;


import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import cn.ibizlab.core.lite.domain.MetaField;
import cn.ibizlab.core.lite.extensions.domain.MetaEntityModel;
import cn.ibizlab.core.lite.extensions.domain.SysModel;
import cn.ibizlab.util.domain.LiquibaseProp;
import com.alibaba.fastjson.JSON;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.integration.ant.type.ChangeLogOutputFile;
import liquibase.integration.commandline.CommandLineUtils;
import cn.ibizlab.core.util.config.LiquibaseGenerateConfiguration;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;

@Slf4j
@Component
public class GenerateLiquibaseChangeLog{

    private Set<ChangeLogOutputFile> changeLogOutputFiles = new LinkedHashSet<>();
    private String includeObjects;
    private String excludeObjects;
    private DataSource dataSource;

    @Value("${ibiz.generateDs.filePath:/app/file/}")
    protected String liquibasePath;

    @Value("${ibiz.generateDs.catalogName:}")
    protected String catalogName;

    @Value("${ibiz.generateDs.generateField:tables,views,columns,indexes,foreignkeys,primarykeys,uniqueconstraints}")
    protected String generateField;

    @Value("${ibiz.generateDs.includeCatalog:false}")
    protected Boolean includeCatalog;

    @Value("${ibiz.generateDs.includeSchema:false}")
    private boolean includeSchema;

    @Value("${ibiz.generateDs.includeTablespace:true}")
    private boolean includeTablespace;

    @Value("${ibiz.generateDs.context:}")
    private String context;

    @Value("${ibiz.generateDs.dataDir:}")
    private String dataDir;

    @Resource
    public LiquibaseGenerateConfiguration liquibaseGenerateConfiguration;

    @SneakyThrows
    public SysModel liquibaseGenerateChangeLog(LiquibaseProp liquibaseProp,String name){
        // 根据指定数据源生成对象
        SpringLiquibase springLiquibase = liquibaseGenerateConfiguration.masterliquibase(liquibaseProp);
        Liquibase liquibase = springLiquibase.createLiquibase(springLiquibase.getDataSource().getConnection());
        Database database = liquibase.getDatabase();
        // 自定义属性参数
        byte[] nameBytes = name.getBytes("UTF-8");
        String fileid = DigestUtils.md5DigestAsHex(nameBytes);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = sdf.format(new Date());

        String fileFullPath = this.liquibasePath+"ibizutil"+ File.separator + fileid+File.separator + fileName;

        DiffOutputControl diffOutputControl = new DiffOutputControl(includeCatalog, includeSchema, includeTablespace, null);
        CommandLineUtils.doGenerateChangeLog(fileFullPath, database, catalogName,liquibaseProp.getDefaultSchema(),StringUtils.trimToNull(generateField),
                name, context, dataDir, diffOutputControl);
        SysModel sysModel = generateSysModel(liquibasePath);
        return sysModel;
    }
    /**
     * 构建一个SysModel对象
     * @param path 生成liquibaseChangeLog路径
     */
    public SysModel generateSysModel(String path) {

        List<MetaEntityModel> metaEntityModels      =       new CopyOnWriteArrayList<>();
        List<Map> primaryKeys                       =       new CopyOnWriteArrayList<>();
        SysModel sysModel                           =       new SysModel();
        MetaEntityModel metaEntityModel             =       null;
        List<Map> commonMessage                     =       null;
        MetaField metaField                         =       null;
        List<Map> column                            =       null;
//      Map primaryKey                              =       null;
        Map head                                    =       null;
        Map temp                                    =       null;

        com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject(ConvertXMLtoJSON(path));
        head = (Map) jsonObject.get("databaseChangeLog");
        commonMessage = (List<Map>) head.get("changeSet");

        // 第一、二层 获取第一个作者以及id
        if (!ObjectUtil.isEmpty(commonMessage)){
            sysModel.setSystemid((String) commonMessage.get(0).get("author"));
            sysModel.setSystemname((String) commonMessage.get(0).get("author"));
        }
//        for (int k = 0 ; k < commonMessage.size(); k++) {
//            // 维护主键组
//            primaryKey = (Map) commonMessage.get(k).get("addPrimaryKey");
//            if (!ObjectUtil.isEmpty(primaryKey)) {
//                primaryKeys.add(primaryKey);
//            }
//        }
        // 第三层 获取实体对象List 在这层还可以放入subEntitys、parentEntitys等关系字段
        for (int i = 0;i < commonMessage.size(); i++) {
            // createTable主要存储了表明以及字段属性,只要crateTable属性，其余剔除
            temp = (Map) commonMessage.get(i).get("createTable");
            if(ObjectUtil.isEmpty(temp)){
                continue;
            }
            metaEntityModel = new MetaEntityModel();
            // 为了获取MetaEntityModel下那些基本类型字段（此处可补充MetaEntityModel等描述字段）
            metaEntityModel.setEntityName(temp.get("tableName") == null ? "" : temp.get("tableName").toString());
            metaEntityModel.setCodeName(temp.get("tableName") == null ? "" : temp.get("tableName").toString());
            metaEntityModel.setTableName(temp.get("tableName") == null ? "" : temp.get("tableName").toString());
            metaEntityModel.setLogicName(temp.get("tableName") == null ? "" : temp.get("tableName").toString());
            // 统一关联sysId
            metaEntityModel.setSystemId((String) commonMessage.get(0).get("author"));

            // 属性List
            column = (List<Map>) temp.get("column");
            List<MetaField> metaFields = new CopyOnWriteArrayList<>();
            for (int j = 0; j < column.size();j++){
                // （此处可补充MetaField描述字段，以及父子外键关系等）
                metaField = new MetaField();
                metaField.setFieldName(column.get(j).get("name") == null? "" : column.get(j).get("name").toString());

                metaField.setDataType(column.get(j).get("type") == null? "" : fieldToName(column.get(j).get("type").toString()));
                metaField.setDataLength(column.get(j).get("type") == null? 0 : fieldToLenth(column.get(j).get("type").toString()));
                metaField.setNullable(column.get(j).get("constraints") != null ? 1 : 0);
//                metaField.setKeyField(isPrimaryKey(primaryKeys,column.get(j).get("name") == null? "" : column.get(j).get("name").toString()) ? 1 : 0);
                metaField.setKeyField(column.get(j).get("primaryKey") != null ? 1 : 0);
                metaField.setPhysicalField(1);
                metaFields.add(metaField);
            }
            metaEntityModel.setFields(metaFields);
            metaEntityModels.add(metaEntityModel);
            sysModel.setEntities(metaEntityModels);
        }
        return sysModel;
    }
//    public static boolean isPrimaryKey(List<Map> primaryKeys,String primaryKey) {
//        boolean flag = false;
//        for (int i = 0; i < primaryKeys.size(); i++) {
//            if (primaryKey.equals(primaryKeys.get(i).get("columnNames"))) {
//                flag = true;
//                break;
//            }
//        }
//        return flag;
//    }
    private static Integer fieldToLenth(String s) {
        if(s.contains("(")) {
            String newStr = s.substring(s.indexOf("(") + 1, s.indexOf(")"));
            return Integer.valueOf(newStr);
        }
        return 0;
    }
    private static String fieldToName(String s) {
        if(s.contains("(")){
            String newStr = s.substring(0, s.indexOf("("));
            return newStr;
        }
        return s;
    }
    Class[] snapshotTypes;
    private Class[] getTypes(Set<Class<? extends DatabaseObject>> types){
        this.snapshotTypes = new Class[types.size()];
        int i = 0;
        for (Class<? extends DatabaseObject> type : types) {
            this.snapshotTypes[i++] = type;
        }
        return snapshotTypes;
    }
    public static String ConvertXMLtoJSON(String path)  {

        InputStream is = null;
        try {
            is = new FileInputStream(path);
            String xml;
            xml = IOUtils.toString(is);
            //将xml转为json
            JSONObject xmlJSONObj = XML.toJSONObject(xml);
            String jsonPrettyPrintString = xmlJSONObj.toString();

            return jsonPrettyPrintString;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SpringLiquibase.SpringResourceOpener createResourceOpener() {
        return new SpringLiquibase().new SpringResourceOpener(getLiquibasePath());
    }

    public String getLiquibasePath() {
        return liquibasePath;
    }

    private DiffOutputControl getDiffOutputControl() {
        DiffOutputControl diffOutputControl = new DiffOutputControl(includeCatalog, includeSchema, includeTablespace, null);

        if ((excludeObjects != null) && (includeObjects != null)) {
            throw new UnexpectedLiquibaseException("Cannot specify both excludeObjects and includeObjects");
        }
        if (excludeObjects != null) {
            diffOutputControl.setObjectChangeFilter(new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, excludeObjects));
        }
        if (includeObjects != null) {
            diffOutputControl.setObjectChangeFilter(new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, includeObjects));
        }

        return diffOutputControl;
    }

    private String getOutputEncoding(ChangeLogOutputFile changeLogOutputFile) {
        String encoding = changeLogOutputFile.getEncoding();
        return (encoding == null) ? getDefaultOutputEncoding() : encoding;
    }

    protected String getDefaultOutputEncoding() {
        LiquibaseConfiguration liquibaseConfiguration = LiquibaseConfiguration.getInstance();
        GlobalConfiguration globalConfiguration = liquibaseConfiguration.getConfiguration(GlobalConfiguration.class);
        return globalConfiguration.getOutputEncoding();
    }
    private Liquibase createLiquibase(String changeLogFile, ResourceAccessor resourceAccessor) {
        Database database =getDataBase();
        ExecutorService.getInstance().clearExecutor(database);
        database.resetInternalState();
        return new Liquibase(changeLogFile, resourceAccessor, database);
    }

    private CatalogAndSchema buildCatalogAndSchema(Database database) {
        return new CatalogAndSchema(database.getDefaultCatalogName(), database.getDefaultSchemaName());
    }

    @SneakyThrows
    public Database getDataBase(){
        Connection connection = null;
        Database database = null;
        String name = "unknown";
        try {
            connection = getDataSource().getConnection();
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            name = database.getDatabaseProductName();
        } catch (SQLException e) {
            throw new DatabaseException(e);
        } finally {
            if (database != null) {
                database.close();
            } else if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                } catch (SQLException e) {
                    log.error("problem closing connection", e);
                }
            }
        }
        return database;
    }

    public DataSource getDataSource() {
        return dataSource;
    }


}
