package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.MetaModule;
import cn.ibizlab.core.lite.service.IMetaModuleService;
import cn.ibizlab.core.lite.filter.MetaModuleSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"模块" })
@RestController("api-metamodule")
@RequestMapping("")
public class MetaModuleResource {

    @Autowired
    public IMetaModuleService metamoduleService;

    @Autowired
    @Lazy
    public MetaModuleMapping metamoduleMapping;

    @ApiOperation(value = "新建模块", tags = {"模块" },  notes = "新建模块")
	@RequestMapping(method = RequestMethod.POST, value = "/metamodules")
    public ResponseEntity<MetaModuleDTO> create(@Validated @RequestBody MetaModuleDTO metamoduledto) {
        MetaModule domain = metamoduleMapping.toDomain(metamoduledto);
		metamoduleService.create(domain);
        MetaModuleDTO dto = metamoduleMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量新建模块", tags = {"模块" },  notes = "批量新建模块")
	@RequestMapping(method = RequestMethod.POST, value = "/metamodules/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<MetaModuleDTO> metamoduledtos) {
        metamoduleService.createBatch(metamoduleMapping.toDomain(metamoduledtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "更新模块", tags = {"模块" },  notes = "更新模块")
	@RequestMapping(method = RequestMethod.PUT, value = "/metamodules/{metamodule_id}")
    public ResponseEntity<MetaModuleDTO> update(@PathVariable("metamodule_id") String metamodule_id, @RequestBody MetaModuleDTO metamoduledto) {
		MetaModule domain  = metamoduleMapping.toDomain(metamoduledto);
        domain .setId(metamodule_id);
		metamoduleService.update(domain );
		MetaModuleDTO dto = metamoduleMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量更新模块", tags = {"模块" },  notes = "批量更新模块")
	@RequestMapping(method = RequestMethod.PUT, value = "/metamodules/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<MetaModuleDTO> metamoduledtos) {
        metamoduleService.updateBatch(metamoduleMapping.toDomain(metamoduledtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "删除模块", tags = {"模块" },  notes = "删除模块")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metamodules/{metamodule_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("metamodule_id") String metamodule_id) {
         return ResponseEntity.status(HttpStatus.OK).body(metamoduleService.remove(metamodule_id));
    }

    @ApiOperation(value = "批量删除模块", tags = {"模块" },  notes = "批量删除模块")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metamodules/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        metamoduleService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取模块", tags = {"模块" },  notes = "获取模块")
	@RequestMapping(method = RequestMethod.GET, value = "/metamodules/{metamodule_id}")
    public ResponseEntity<MetaModuleDTO> get(@PathVariable("metamodule_id") String metamodule_id) {
        MetaModule domain = metamoduleService.get(metamodule_id);
        MetaModuleDTO dto = metamoduleMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取模块草稿", tags = {"模块" },  notes = "获取模块草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/metamodules/getdraft")
    public ResponseEntity<MetaModuleDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(metamoduleMapping.toDto(metamoduleService.getDraft(new MetaModule())));
    }

    @ApiOperation(value = "检查模块", tags = {"模块" },  notes = "检查模块")
	@RequestMapping(method = RequestMethod.POST, value = "/metamodules/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody MetaModuleDTO metamoduledto) {
        return  ResponseEntity.status(HttpStatus.OK).body(metamoduleService.checkKey(metamoduleMapping.toDomain(metamoduledto)));
    }

    @ApiOperation(value = "保存模块", tags = {"模块" },  notes = "保存模块")
	@RequestMapping(method = RequestMethod.POST, value = "/metamodules/save")
    public ResponseEntity<Boolean> save(@RequestBody MetaModuleDTO metamoduledto) {
        return ResponseEntity.status(HttpStatus.OK).body(metamoduleService.save(metamoduleMapping.toDomain(metamoduledto)));
    }

    @ApiOperation(value = "批量保存模块", tags = {"模块" },  notes = "批量保存模块")
	@RequestMapping(method = RequestMethod.POST, value = "/metamodules/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<MetaModuleDTO> metamoduledtos) {
        metamoduleService.saveBatch(metamoduleMapping.toDomain(metamoduledtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取数据集", tags = {"模块" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/metamodules/fetchdefault")
	public ResponseEntity<List<MetaModuleDTO>> fetchDefault(MetaModuleSearchContext context) {
        Page<MetaModule> domains = metamoduleService.searchDefault(context) ;
        List<MetaModuleDTO> list = metamoduleMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "查询数据集", tags = {"模块" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/metamodules/searchdefault")
	public ResponseEntity<Page<MetaModuleDTO>> searchDefault(@RequestBody MetaModuleSearchContext context) {
        Page<MetaModule> domains = metamoduleService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(metamoduleMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

