package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.DstMicroservice;
import cn.ibizlab.core.lite.service.IDstMicroserviceService;
import cn.ibizlab.core.lite.filter.DstMicroserviceSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"微服务" })
@RestController("api-dstmicroservice")
@RequestMapping("")
public class DstMicroserviceResource {

    @Autowired
    public IDstMicroserviceService dstmicroserviceService;

    @Autowired
    @Lazy
    public DstMicroserviceMapping dstmicroserviceMapping;

    @ApiOperation(value = "新建微服务", tags = {"微服务" },  notes = "新建微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices")
    public ResponseEntity<DstMicroserviceDTO> create(@Validated @RequestBody DstMicroserviceDTO dstmicroservicedto) {
        DstMicroservice domain = dstmicroserviceMapping.toDomain(dstmicroservicedto);
		dstmicroserviceService.create(domain);
        DstMicroserviceDTO dto = dstmicroserviceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量新建微服务", tags = {"微服务" },  notes = "批量新建微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DstMicroserviceDTO> dstmicroservicedtos) {
        dstmicroserviceService.createBatch(dstmicroserviceMapping.toDomain(dstmicroservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "更新微服务", tags = {"微服务" },  notes = "更新微服务")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstmicroservices/{dstmicroservice_id}")
    public ResponseEntity<DstMicroserviceDTO> update(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstMicroserviceDTO dstmicroservicedto) {
		DstMicroservice domain  = dstmicroserviceMapping.toDomain(dstmicroservicedto);
        domain .setId(dstmicroservice_id);
		dstmicroserviceService.update(domain );
		DstMicroserviceDTO dto = dstmicroserviceMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量更新微服务", tags = {"微服务" },  notes = "批量更新微服务")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstmicroservices/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DstMicroserviceDTO> dstmicroservicedtos) {
        dstmicroserviceService.updateBatch(dstmicroserviceMapping.toDomain(dstmicroservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "删除微服务", tags = {"微服务" },  notes = "删除微服务")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstmicroservices/{dstmicroservice_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("dstmicroservice_id") String dstmicroservice_id) {
         return ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceService.remove(dstmicroservice_id));
    }

    @ApiOperation(value = "批量删除微服务", tags = {"微服务" },  notes = "批量删除微服务")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstmicroservices/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        dstmicroserviceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取微服务", tags = {"微服务" },  notes = "获取微服务")
	@RequestMapping(method = RequestMethod.GET, value = "/dstmicroservices/{dstmicroservice_id}")
    public ResponseEntity<DstMicroserviceDTO> get(@PathVariable("dstmicroservice_id") String dstmicroservice_id) {
        DstMicroservice domain = dstmicroserviceService.get(dstmicroservice_id);
        DstMicroserviceDTO dto = dstmicroserviceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取微服务草稿", tags = {"微服务" },  notes = "获取微服务草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/dstmicroservices/getdraft")
    public ResponseEntity<DstMicroserviceDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceMapping.toDto(dstmicroserviceService.getDraft(new DstMicroservice())));
    }

    @ApiOperation(value = "检查微服务", tags = {"微服务" },  notes = "检查微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DstMicroserviceDTO dstmicroservicedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceService.checkKey(dstmicroserviceMapping.toDomain(dstmicroservicedto)));
    }

    @ApiOperation(value = "保存微服务", tags = {"微服务" },  notes = "保存微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/save")
    public ResponseEntity<Boolean> save(@RequestBody DstMicroserviceDTO dstmicroservicedto) {
        return ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceService.save(dstmicroserviceMapping.toDomain(dstmicroservicedto)));
    }

    @ApiOperation(value = "批量保存微服务", tags = {"微服务" },  notes = "批量保存微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DstMicroserviceDTO> dstmicroservicedtos) {
        dstmicroserviceService.saveBatch(dstmicroserviceMapping.toDomain(dstmicroservicedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取数据集", tags = {"微服务" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstmicroservices/fetchdefault")
	public ResponseEntity<List<DstMicroserviceDTO>> fetchDefault(DstMicroserviceSearchContext context) {
        Page<DstMicroservice> domains = dstmicroserviceService.searchDefault(context) ;
        List<DstMicroserviceDTO> list = dstmicroserviceMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "查询数据集", tags = {"微服务" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstmicroservices/searchdefault")
	public ResponseEntity<Page<DstMicroserviceDTO>> searchDefault(@RequestBody DstMicroserviceSearchContext context) {
        Page<DstMicroservice> domains = dstmicroserviceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstmicroserviceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @ApiOperation(value = "根据系统建立微服务", tags = {"微服务" },  notes = "根据系统建立微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices")
    public ResponseEntity<DstMicroserviceDTO> createByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @RequestBody DstMicroserviceDTO dstmicroservicedto) {
        DstMicroservice domain = dstmicroserviceMapping.toDomain(dstmicroservicedto);
        domain.setPssystemid(dstsystem_id);
		dstmicroserviceService.create(domain);
        DstMicroserviceDTO dto = dstmicroserviceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统批量建立微服务", tags = {"微服务" },  notes = "根据系统批量建立微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/batch")
    public ResponseEntity<Boolean> createBatchByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @RequestBody List<DstMicroserviceDTO> dstmicroservicedtos) {
        List<DstMicroservice> domainlist=dstmicroserviceMapping.toDomain(dstmicroservicedtos);
        for(DstMicroservice domain:domainlist){
            domain.setPssystemid(dstsystem_id);
        }
        dstmicroserviceService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据系统更新微服务", tags = {"微服务" },  notes = "根据系统更新微服务")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}")
    public ResponseEntity<DstMicroserviceDTO> updateByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstMicroserviceDTO dstmicroservicedto) {
        DstMicroservice domain = dstmicroserviceMapping.toDomain(dstmicroservicedto);
        domain.setPssystemid(dstsystem_id);
        domain.setId(dstmicroservice_id);
		dstmicroserviceService.update(domain);
        DstMicroserviceDTO dto = dstmicroserviceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统批量更新微服务", tags = {"微服务" },  notes = "根据系统批量更新微服务")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstmicroservices/batch")
    public ResponseEntity<Boolean> updateBatchByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @RequestBody List<DstMicroserviceDTO> dstmicroservicedtos) {
        List<DstMicroservice> domainlist=dstmicroserviceMapping.toDomain(dstmicroservicedtos);
        for(DstMicroservice domain:domainlist){
            domain.setPssystemid(dstsystem_id);
        }
        dstmicroserviceService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据系统删除微服务", tags = {"微服务" },  notes = "根据系统删除微服务")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}")
    public ResponseEntity<Boolean> removeByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id) {
		return ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceService.remove(dstmicroservice_id));
    }

    @ApiOperation(value = "根据系统批量删除微服务", tags = {"微服务" },  notes = "根据系统批量删除微服务")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstmicroservices/batch")
    public ResponseEntity<Boolean> removeBatchByDstSystem(@RequestBody List<String> ids) {
        dstmicroserviceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据系统获取微服务", tags = {"微服务" },  notes = "根据系统获取微服务")
	@RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}")
    public ResponseEntity<DstMicroserviceDTO> getByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id) {
        DstMicroservice domain = dstmicroserviceService.get(dstmicroservice_id);
        DstMicroserviceDTO dto = dstmicroserviceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统获取微服务草稿", tags = {"微服务" },  notes = "根据系统获取微服务草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstmicroservices/getdraft")
    public ResponseEntity<DstMicroserviceDTO> getDraftByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id) {
        DstMicroservice domain = new DstMicroservice();
        domain.setPssystemid(dstsystem_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceMapping.toDto(dstmicroserviceService.getDraft(domain)));
    }

    @ApiOperation(value = "根据系统检查微服务", tags = {"微服务" },  notes = "根据系统检查微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @RequestBody DstMicroserviceDTO dstmicroservicedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceService.checkKey(dstmicroserviceMapping.toDomain(dstmicroservicedto)));
    }

    @ApiOperation(value = "根据系统保存微服务", tags = {"微服务" },  notes = "根据系统保存微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/save")
    public ResponseEntity<Boolean> saveByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @RequestBody DstMicroserviceDTO dstmicroservicedto) {
        DstMicroservice domain = dstmicroserviceMapping.toDomain(dstmicroservicedto);
        domain.setPssystemid(dstsystem_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstmicroserviceService.save(domain));
    }

    @ApiOperation(value = "根据系统批量保存微服务", tags = {"微服务" },  notes = "根据系统批量保存微服务")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @RequestBody List<DstMicroserviceDTO> dstmicroservicedtos) {
        List<DstMicroservice> domainlist=dstmicroserviceMapping.toDomain(dstmicroservicedtos);
        for(DstMicroservice domain:domainlist){
             domain.setPssystemid(dstsystem_id);
        }
        dstmicroserviceService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "根据系统获取数据集", tags = {"微服务" } ,notes = "根据系统获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstsystems/{dstsystem_id}/dstmicroservices/fetchdefault")
	public ResponseEntity<List<DstMicroserviceDTO>> fetchDstMicroserviceDefaultByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id,DstMicroserviceSearchContext context) {
        context.setN_systemid_eq(dstsystem_id);
        Page<DstMicroservice> domains = dstmicroserviceService.searchDefault(context) ;
        List<DstMicroserviceDTO> list = dstmicroserviceMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "根据系统查询数据集", tags = {"微服务" } ,notes = "根据系统查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstsystems/{dstsystem_id}/dstmicroservices/searchdefault")
	public ResponseEntity<Page<DstMicroserviceDTO>> searchDstMicroserviceDefaultByDstSystem(@PathVariable("dstsystem_id") String dstsystem_id, @RequestBody DstMicroserviceSearchContext context) {
        context.setN_systemid_eq(dstsystem_id);
        Page<DstMicroservice> domains = dstmicroserviceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstmicroserviceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

