package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[MetaModuleDTO]
 */
@Data
public class MetaModuleDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [MODULEID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [MODULENAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String name;

    /**
     * 属性 [CODENAME]
     *
     */
    @JSONField(name = "codename")
    @JsonProperty("codename")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String codename;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "systemid")
    @JsonProperty("systemid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemid;


    /**
     * 设置 [MODULENAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("modulename",name);
    }

    /**
     * 设置 [CODENAME]
     */
    public void setCodename(String  codename){
        this.codename = codename ;
        this.modify("codename",codename);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemid(String  systemid){
        this.systemid = systemid ;
        this.modify("systemid",systemid);
    }


}


