package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DstLookupDTO]
 */
@Data
public class DstLookupDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [RELATIONID]
     *
     */
    @JSONField(name = "relationid")
    @JsonProperty("relationid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String relationid;

    /**
     * 属性 [FIELDNAME]
     *
     */
    @JSONField(name = "fieldname")
    @JsonProperty("fieldname")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String fieldname;

    /**
     * 属性 [REFFIELDNAME]
     *
     */
    @JSONField(name = "reffieldname")
    @JsonProperty("reffieldname")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String reffieldname;


    /**
     * 设置 [RELATIONID]
     */
    public void setRelationid(String  relationid){
        this.relationid = relationid ;
        this.modify("relationid",relationid);
    }

    /**
     * 设置 [FIELDNAME]
     */
    public void setFieldname(String  fieldname){
        this.fieldname = fieldname ;
        this.modify("fieldname",fieldname);
    }

    /**
     * 设置 [REFFIELDNAME]
     */
    public void setReffieldname(String  reffieldname){
        this.reffieldname = reffieldname ;
        this.modify("reffieldname",reffieldname);
    }


}


