package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[BladeVisualCategoryDTO]
 */
@Data
public class BladeVisualCategoryDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 属性 [CATEGORY_KEY]
     *
     */
    @JSONField(name = "categorykey")
    @JsonProperty("categorykey")
    @Size(min = 0, max = 12, message = "内容长度必须小于等于[12]")
    private String categorykey;

    /**
     * 属性 [CATEGORY_VALUE]
     *
     */
    @JSONField(name = "categoryvalue")
    @JsonProperty("categoryvalue")
    @Size(min = 0, max = 64, message = "内容长度必须小于等于[64]")
    private String categoryvalue;

    /**
     * 属性 [IS_DELETED]
     *
     */
    @JSONField(name = "isdeleted")
    @JsonProperty("isdeleted")
    private Integer isdeleted;


    /**
     * 设置 [CATEGORY_KEY]
     */
    public void setCategorykey(String  categorykey){
        this.categorykey = categorykey ;
        this.modify("category_key",categorykey);
    }

    /**
     * 设置 [CATEGORY_VALUE]
     */
    public void setCategoryvalue(String  categoryvalue){
        this.categoryvalue = categoryvalue ;
        this.modify("category_value",categoryvalue);
    }


}


