package cn.ibizlab.core.util.config;

import cn.ibizlab.util.domain.LiquibaseProp;
import com.alibaba.druid.pool.DruidDataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LiquibaseGenerateConfiguration {

    @Bean
    public SpringLiquibase masterliquibase(LiquibaseProp masterProperties) {
        return getLiquibase(masterProperties.getUsername(),masterProperties.getPassword(),masterProperties.getUrl(),masterProperties.getDefaultSchema());
    }

    public SpringLiquibase getLiquibase(String username, String password, String url, String defaultSchema) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUsername(username);
        druidDataSource.setPassword(password);
        druidDataSource.setUrl(url);

        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(druidDataSource);
        liquibase.setChangeLog("classpath:liquibase/empty.xml");
        liquibase.setContexts("development,test,production");
        liquibase.setShouldRun(true);
        liquibase.setDefaultSchema(defaultSchema);
        return liquibase;
    }
}
