package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.MetaRelationship;
import cn.ibizlab.core.lite.filter.MetaRelationshipSearchContext;
import cn.ibizlab.core.lite.service.IMetaRelationshipService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.MetaRelationshipMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[实体关系] 服务对象接口实现
 */
@Slf4j
@Service("MetaRelationshipServiceImpl")
public class MetaRelationshipServiceImpl extends ServiceImpl<MetaRelationshipMapper, MetaRelationship> implements IMetaRelationshipService {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaFieldService metafieldService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaEntityService metaentityService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(MetaRelationship et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<MetaRelationship> list) {
        list.forEach(item->fillParentData(item));
        this.saveOrUpdateBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(MetaRelationship et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("relationid", et.getId()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<MetaRelationship> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public MetaRelationship get(String key) {
        MetaRelationship et = getById(key);
        if(et == null){
            et = new MetaRelationship();
            et.setId(key);
        }
        else {
        }
        return et;
    }

    @Override
    public MetaRelationship getDraft(MetaRelationship et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(MetaRelationship et) {
        return (!ObjectUtils.isEmpty(et.getId())) && (!Objects.isNull(this.getById(et.getId())));
    }
    @Override
    @Transactional
    public boolean save(MetaRelationship et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(MetaRelationship et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<MetaRelationship> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<MetaRelationship> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<MetaRelationship> selectByEntityId(String entity_id) {
        return baseMapper.selectByEntityId(entity_id);
    }
    @Override
    public void removeByEntityId(String entity_id) {
        this.remove(new QueryWrapper<MetaRelationship>().eq("entityid",entity_id));
    }

    @Autowired
    @Lazy
    IMetaRelationshipService proxyService;
	@Override
    public void saveByEntityId(String entity_id,List<MetaRelationship> list) {
        if(list==null)
            return;
        Set<String> delIds=new HashSet<String>();
        List<MetaRelationship> _update=new ArrayList<MetaRelationship>();
        List<MetaRelationship> _create=new ArrayList<MetaRelationship>();
        for(MetaRelationship before:selectByEntityId(entity_id)){
            delIds.add(before.getId());
        }
        for(MetaRelationship sub:list) {
            sub.setEntityId(entity_id);
            if(ObjectUtils.isEmpty(sub.getId()))
                sub.setId((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getId())) {
                delIds.remove(sub.getId());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}

	@Override
    public List<MetaRelationship> selectByRefEntityId(String entity_id) {
        return baseMapper.selectByRefEntityId(entity_id);
    }
    @Override
    public void removeByRefEntityId(String entity_id) {
        this.remove(new QueryWrapper<MetaRelationship>().eq("refentityid",entity_id));
    }

	@Override
    public void saveByRefEntityId(String entity_id,List<MetaRelationship> list) {
        if(list==null)
            return;
        Set<String> delIds=new HashSet<String>();
        List<MetaRelationship> _update=new ArrayList<MetaRelationship>();
        List<MetaRelationship> _create=new ArrayList<MetaRelationship>();
        for(MetaRelationship before:selectByRefEntityId(entity_id)){
            delIds.add(before.getId());
        }
        for(MetaRelationship sub:list) {
            sub.setRefEntityId(entity_id);
            if(ObjectUtils.isEmpty(sub.getId()))
                sub.setId((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getId())) {
                delIds.remove(sub.getId());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}


    /**
     * 查询集合 数据集
     */
    @Override
    public Page<MetaRelationship> searchDefault(MetaRelationshipSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<MetaRelationship> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<MetaRelationship>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(MetaRelationship et){
        //实体关系[DER1N_META_RELATION_META_ENTITY_ENTITYID]
        if(!ObjectUtils.isEmpty(et.getEntityId())){
            cn.ibizlab.core.lite.domain.MetaEntity entity=et.getEntity();
            if(ObjectUtils.isEmpty(entity)){
                cn.ibizlab.core.lite.domain.MetaEntity majorEntity=metaentityService.get(et.getEntityId());
                et.setEntity(majorEntity);
                entity=majorEntity;
            }
            et.setEntityName(entity.getEntityName());
            et.setSystemId(entity.getSystemId());
        }
        //实体关系[DER1N_META_RELATION_META_ENTITY_REFENTITYID]
        if(!ObjectUtils.isEmpty(et.getRefEntityId())){
            cn.ibizlab.core.lite.domain.MetaEntity reference=et.getReference();
            if(ObjectUtils.isEmpty(reference)){
                cn.ibizlab.core.lite.domain.MetaEntity majorEntity=metaentityService.get(et.getRefEntityId());
                et.setReference(majorEntity);
                reference=majorEntity;
            }
            et.setRefEntityName(reference.getEntityName());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }





}



