package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.MetaField;
import cn.ibizlab.core.lite.filter.MetaFieldSearchContext;
import cn.ibizlab.core.lite.service.IMetaFieldService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.MetaFieldMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[属性] 服务对象接口实现
 */
@Slf4j
@Service("MetaFieldServiceImpl")
public class MetaFieldServiceImpl extends ServiceImpl<MetaFieldMapper, MetaField> implements IMetaFieldService {


    protected cn.ibizlab.core.lite.service.IMetaFieldService metafieldService = this;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaEntityService metaentityService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaRelationshipService metarelationshipService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(MetaField et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getFieldId()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<MetaField> list) {
        list.forEach(item->fillParentData(item));
        this.saveOrUpdateBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(MetaField et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("fieldid", et.getFieldId()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getFieldId()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<MetaField> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public MetaField get(String key) {
        MetaField et = getById(key);
        if(et == null){
            et = new MetaField();
            et.setFieldId(key);
        }
        else {
        }
        return et;
    }

    @Override
    public MetaField getDraft(MetaField et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(MetaField et) {
        return (!ObjectUtils.isEmpty(et.getFieldId())) && (!Objects.isNull(this.getById(et.getFieldId())));
    }
    @Override
    @Transactional
    public boolean save(MetaField et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(MetaField et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<MetaField> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<MetaField> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<MetaField> selectByEntityId(String entity_id) {
        return baseMapper.selectByEntityId(entity_id);
    }
    @Override
    public void removeByEntityId(String entity_id) {
        this.remove(new QueryWrapper<MetaField>().eq("entityid",entity_id));
    }

    @Autowired
    @Lazy
    IMetaFieldService proxyService;
	@Override
    public void saveByEntityId(String entity_id,List<MetaField> list) {
        if(list==null)
            return;
        Set<String> delIds=new HashSet<String>();
        List<MetaField> _update=new ArrayList<MetaField>();
        List<MetaField> _create=new ArrayList<MetaField>();
        for(MetaField before:selectByEntityId(entity_id)){
            delIds.add(before.getFieldId());
        }
        for(MetaField sub:list) {
            sub.setEntityId(entity_id);
            if(ObjectUtils.isEmpty(sub.getFieldId()))
                sub.setFieldId((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getFieldId())) {
                delIds.remove(sub.getFieldId());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}

	@Override
    public List<MetaField> selectByRefFieldId(String field_id) {
        return baseMapper.selectByRefFieldId(field_id);
    }
    @Override
    public void removeByRefFieldId(String field_id) {
        this.remove(new QueryWrapper<MetaField>().eq("reffieldid",field_id));
    }

	@Override
    public List<MetaField> selectByRelationId(String id) {
        return baseMapper.selectByRelationId(id);
    }
    @Override
    public void removeByRelationId(String id) {
        this.remove(new QueryWrapper<MetaField>().eq("relationid",id));
    }


    /**
     * 查询集合 数据集
     */
    @Override
    public Page<MetaField> searchDefault(MetaFieldSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<MetaField> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<MetaField>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(MetaField et){
        //实体关系[DER1N_META_FIELD_META_ENTITY_ENTITYID]
        if(!ObjectUtils.isEmpty(et.getEntityId())){
            cn.ibizlab.core.lite.domain.MetaEntity entity=et.getEntity();
            if(ObjectUtils.isEmpty(entity)){
                cn.ibizlab.core.lite.domain.MetaEntity majorEntity=metaentityService.get(et.getEntityId());
                et.setEntity(majorEntity);
                entity=majorEntity;
            }
            et.setEntityName(entity.getEntityName());
            et.setEntityCodeName(entity.getCodeName());
            et.setSystemId(entity.getSystemId());
        }
        //实体关系[DER1N_META_FIELD_META_FIELD_REFFIELDID]
        if(!ObjectUtils.isEmpty(et.getRefFieldId())){
            cn.ibizlab.core.lite.domain.MetaField reffield=et.getReffield();
            if(ObjectUtils.isEmpty(reffield)){
                cn.ibizlab.core.lite.domain.MetaField majorEntity=metafieldService.get(et.getRefFieldId());
                et.setReffield(majorEntity);
                reffield=majorEntity;
            }
            et.setRefFieldName(reffield.getFieldName());
        }
        //实体关系[DER1N_META_FIELD_META_RELATION_RELATIONID]
        if(!ObjectUtils.isEmpty(et.getRelationId())){
            cn.ibizlab.core.lite.domain.MetaRelationship relation=et.getRelation();
            if(ObjectUtils.isEmpty(relation)){
                cn.ibizlab.core.lite.domain.MetaRelationship majorEntity=metarelationshipService.get(et.getRelationId());
                et.setRelation(majorEntity);
                relation=majorEntity;
            }
            et.setRelationName(relation.getName());
            et.setRefEntityName(relation.getRefEntityName());
            et.setRelationCodeName(relation.getCodeName());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }





}



