package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.MetaDataSet;
import cn.ibizlab.core.lite.filter.MetaDataSetSearchContext;
import cn.ibizlab.core.lite.service.IMetaDataSetService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.MetaDataSetMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[数据集] 服务对象接口实现
 */
@Slf4j
@Service("MetaDataSetServiceImpl")
public class MetaDataSetServiceImpl extends ServiceImpl<MetaDataSetMapper, MetaDataSet> implements IMetaDataSetService {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaEntityService metaentityService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(MetaDataSet et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getDatasetId()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<MetaDataSet> list) {
        list.forEach(item->fillParentData(item));
        this.saveOrUpdateBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(MetaDataSet et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("datasetid", et.getDatasetId()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getDatasetId()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<MetaDataSet> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public MetaDataSet get(String key) {
        MetaDataSet et = getById(key);
        if(et == null){
            et = new MetaDataSet();
            et.setDatasetId(key);
        }
        else {
        }
        return et;
    }

    @Override
    public MetaDataSet getDraft(MetaDataSet et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(MetaDataSet et) {
        return (!ObjectUtils.isEmpty(et.getDatasetId())) && (!Objects.isNull(this.getById(et.getDatasetId())));
    }
    @Override
    @Transactional
    public boolean save(MetaDataSet et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(MetaDataSet et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<MetaDataSet> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<MetaDataSet> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<MetaDataSet> selectByEntityId(String entity_id) {
        return baseMapper.selectByEntityId(entity_id);
    }
    @Override
    public void removeByEntityId(String entity_id) {
        this.remove(new QueryWrapper<MetaDataSet>().eq("entityid",entity_id));
    }

    @Autowired
    @Lazy
    IMetaDataSetService proxyService;
	@Override
    public void saveByEntityId(String entity_id,List<MetaDataSet> list) {
        if(list==null)
            return;
        Set<String> delIds=new HashSet<String>();
        List<MetaDataSet> _update=new ArrayList<MetaDataSet>();
        List<MetaDataSet> _create=new ArrayList<MetaDataSet>();
        for(MetaDataSet before:selectByEntityId(entity_id)){
            delIds.add(before.getDatasetId());
        }
        for(MetaDataSet sub:list) {
            sub.setEntityId(entity_id);
            if(ObjectUtils.isEmpty(sub.getDatasetId()))
                sub.setDatasetId((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getDatasetId())) {
                delIds.remove(sub.getDatasetId());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}


    /**
     * 查询集合 数据集
     */
    @Override
    public Page<MetaDataSet> searchDefault(MetaDataSetSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<MetaDataSet> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<MetaDataSet>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(MetaDataSet et){
        //实体关系[DER1N_META_DATASET_META_ENTITY_ENTITYID]
        if(!ObjectUtils.isEmpty(et.getEntityId())){
            cn.ibizlab.core.lite.domain.MetaEntity entity=et.getEntity();
            if(ObjectUtils.isEmpty(entity)){
                cn.ibizlab.core.lite.domain.MetaEntity majorEntity=metaentityService.get(et.getEntityId());
                et.setEntity(majorEntity);
                entity=majorEntity;
            }
            et.setEntityName(entity.getEntityName());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }





}



