package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.DstView;
import cn.ibizlab.core.lite.filter.DstViewSearchContext;
import cn.ibizlab.core.lite.service.IDstViewService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.DstViewMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[页面] 服务对象接口实现
 */
@Slf4j
@Service("DstViewServiceImpl")
public class DstViewServiceImpl extends ServiceImpl<DstViewMapper, DstView> implements IDstViewService {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IDstSystemService dstsystemService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaEntityService metaentityService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(DstView et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<DstView> list) {
        list.forEach(item->fillParentData(item));
        this.saveOrUpdateBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(DstView et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("viewid", et.getId()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<DstView> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public DstView get(String key) {
        DstView et = getById(key);
        if(et == null){
            et = new DstView();
            et.setId(key);
        }
        else {
        }
        return et;
    }

    @Override
    public DstView getDraft(DstView et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(DstView et) {
        return (!ObjectUtils.isEmpty(et.getId())) && (!Objects.isNull(this.getById(et.getId())));
    }
    @Override
    @Transactional
    public boolean save(DstView et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(DstView et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<DstView> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<DstView> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<DstView> selectByAppId(String id) {
        return baseMapper.selectByAppId(id);
    }
    @Override
    public void removeByAppId(String id) {
        this.remove(new QueryWrapper<DstView>().eq("appid",id));
    }

	@Override
    public List<DstView> selectBySystemId(String pssystemid) {
        return baseMapper.selectBySystemId(pssystemid);
    }
    @Override
    public void removeBySystemId(String pssystemid) {
        this.remove(new QueryWrapper<DstView>().eq("systemid",pssystemid));
    }

	@Override
    public List<DstView> selectByEntityId(String entity_id) {
        return baseMapper.selectByEntityId(entity_id);
    }
    @Override
    public void removeByEntityId(String entity_id) {
        this.remove(new QueryWrapper<DstView>().eq("entityid",entity_id));
    }


    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DstView> searchDefault(DstViewSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<DstView> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<DstView>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(DstView et){
        //实体关系[DER1N_DST_VIEW_META_ENTITY_ENTITYID]
        if(!ObjectUtils.isEmpty(et.getEntityId())){
            cn.ibizlab.core.lite.domain.MetaEntity factEntity=et.getFactEntity();
            if(ObjectUtils.isEmpty(factEntity)){
                cn.ibizlab.core.lite.domain.MetaEntity majorEntity=metaentityService.get(et.getEntityId());
                et.setFactEntity(majorEntity);
                factEntity=majorEntity;
            }
            et.setEntityName(factEntity.getEntityName());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }





}



