package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.DstRouter;
import cn.ibizlab.core.lite.filter.DstRouterSearchContext;
import cn.ibizlab.core.lite.service.IDstRouterService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.DstRouterMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[路由] 服务对象接口实现
 */
@Slf4j
@Service("DstRouterServiceImpl")
public class DstRouterServiceImpl extends ServiceImpl<DstRouterMapper, DstRouter> implements IDstRouterService {


    protected cn.ibizlab.core.lite.service.IDstRouterService dstrouterService = this;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IDstSystemService dstsystemService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(DstRouter et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<DstRouter> list) {
        this.saveOrUpdateBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(DstRouter et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("routerid", et.getId()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getId()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<DstRouter> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public DstRouter get(String key) {
        DstRouter et = getById(key);
        if(et == null){
            et = new DstRouter();
            et.setId(key);
        }
        else {
        }
        return et;
    }

    @Override
    public DstRouter getDraft(DstRouter et) {
        return et;
    }

    @Override
    public boolean checkKey(DstRouter et) {
        return (!ObjectUtils.isEmpty(et.getId())) && (!Objects.isNull(this.getById(et.getId())));
    }
    @Override
    @Transactional
    public boolean save(DstRouter et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(DstRouter et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<DstRouter> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<DstRouter> list) {
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<DstRouter> selectByAppId(String id) {
        return baseMapper.selectByAppId(id);
    }
    @Override
    public void removeByAppId(String id) {
        this.remove(new QueryWrapper<DstRouter>().eq("appid",id));
    }

	@Override
    public List<DstRouter> selectByParentid(String id) {
        return baseMapper.selectByParentid(id);
    }
    @Override
    public void removeByParentid(String id) {
        this.remove(new QueryWrapper<DstRouter>().eq("parentid",id));
    }

	@Override
    public List<DstRouter> selectBySystemId(String pssystemid) {
        return baseMapper.selectBySystemId(pssystemid);
    }
    @Override
    public void removeBySystemId(String pssystemid) {
        this.remove(new QueryWrapper<DstRouter>().eq("systemid",pssystemid));
    }


    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DstRouter> searchDefault(DstRouterSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<DstRouter> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<DstRouter>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }





}



