package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.MetaRelationship;
import cn.ibizlab.core.lite.filter.MetaRelationshipSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[MetaRelationship] 服务对象接口
 */
public interface IMetaRelationshipService extends IService<MetaRelationship> {

    boolean create(MetaRelationship et);
    void createBatch(List<MetaRelationship> list);
    boolean update(MetaRelationship et);
    void updateBatch(List<MetaRelationship> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    MetaRelationship get(String key);
    MetaRelationship getDraft(MetaRelationship et);
    boolean checkKey(MetaRelationship et);
    boolean save(MetaRelationship et);
    void saveBatch(List<MetaRelationship> list);
    Page<MetaRelationship> searchDefault(MetaRelationshipSearchContext context);
    List<MetaRelationship> selectByEntityId(String entity_id);
    void removeByEntityId(String entity_id);
    void saveByEntityId(String entity_id, List<MetaRelationship> list) ;
    List<MetaRelationship> selectByRefEntityId(String entity_id);
    void removeByRefEntityId(String entity_id);
    void saveByRefEntityId(String entity_id, List<MetaRelationship> list) ;
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


